/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.issue.Issue;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

@ExperimentalApi
public class RapidViewIssue {
    private final Issue issue;
    private final Epic epic;
    private final Sprint sprint;
    private final Set<Sprint> closedSprints;
    private final boolean flagged;

    private RapidViewIssue(Issue issue, Epic epic, Sprint sprint, Set<Sprint> closedSprints, boolean flagged) {
        this.issue = issue;
        this.epic = epic;
        this.sprint = sprint;
        this.closedSprints = closedSprints;
        this.flagged = flagged;
    }

    public Issue getIssue() {
        return this.issue;
    }

    @Nullable
    public Epic getEpic() {
        return this.epic;
    }

    @Nullable
    public Sprint getSprint() {
        return this.sprint;
    }

    public Set<Sprint> getClosedSprints() {
        return this.closedSprints;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public static RapidViewIssueBuilder builder(Issue issue) {
        return new RapidViewIssueBuilder(issue);
    }

    public static class RapidViewIssueBuilder {
        private final Issue issue;
        private Epic epic = null;
        private Sprint sprint = null;
        private Set<Sprint> completedSprintIds = Collections.emptySet();
        private boolean flagged = false;

        public RapidViewIssueBuilder(Issue issue) {
            this.issue = issue;
        }

        public RapidViewIssueBuilder epic(Epic epic) {
            this.epic = epic;
            return this;
        }

        public RapidViewIssueBuilder sprint(Sprint sprint) {
            this.sprint = sprint;
            return this;
        }

        public RapidViewIssueBuilder closedSprints(Set<Sprint> completedSprintIds) {
            this.completedSprintIds = completedSprintIds == null ? Collections.emptySet() : completedSprintIds;
            return this;
        }

        public RapidViewIssueBuilder flagged(boolean flagged) {
            this.flagged = flagged;
            return this;
        }

        public RapidViewIssue build() {
            return new RapidViewIssue(this.issue, this.epic, this.sprint, this.completedSprintIds, this.flagged);
        }
    }
}

