/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.annotations.PublicApi;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
public class Pages {
    public static <T> Page<T> toPage(Iterable<T> values, PageRequest request, @Nullable Long total) {
        int limit = request.getLimit();
        Iterable valuesWithoutBeginning = Iterables.skip(values, (int)request.getStart().intValue());
        ImmutableList valuesWithOneAdditional = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)valuesWithoutBeginning, (int)(limit + 1)));
        boolean isLast = valuesWithOneAdditional.size() <= limit;
        ImmutableList valuesInRange = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)valuesWithOneAdditional, (int)limit));
        return new Builder((List)valuesInRange).start(request.getStart()).maxResults(limit).isLast(isLast).total(total).build();
    }

    public static <T> Builder<T> builder(@Nonnull List<T> values) {
        return new Builder(values);
    }

    @Immutable
    private static final class PageImpl<T>
    implements Page<T> {
        private final Long start;
        private final Long total;
        private final Integer maxResults;
        private final Boolean isLast;
        private final List<T> values;

        public PageImpl(Long start, Integer maxResults, @Nullable Long total, Boolean isLast, List<T> values) {
            this.start = start;
            this.isLast = isLast;
            this.maxResults = maxResults;
            this.total = total;
            this.values = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(values)));
        }

        @Override
        public Long getStart() {
            return this.start;
        }

        @Override
        public Integer maxResults() {
            return this.maxResults;
        }

        @Override
        @Nullable
        public Long getTotal() {
            return this.total;
        }

        @Override
        public Boolean isLast() {
            return this.isLast;
        }

        @Override
        public List<T> getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageImpl page = (PageImpl)o;
            if (!this.start.equals(page.start)) {
                return false;
            }
            if (this.total != null ? !this.total.equals(page.total) : page.total != null) {
                return false;
            }
            if (!this.maxResults.equals(page.maxResults)) {
                return false;
            }
            if (!this.isLast.equals(page.isLast)) {
                return false;
            }
            return this.values.equals(page.values);
        }

        public int hashCode() {
            int result = this.start.hashCode();
            result = 31 * result + (this.total != null ? this.total.hashCode() : 0);
            result = 31 * result + this.maxResults.hashCode();
            result = 31 * result + this.isLast.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }

        public String toString() {
            return "PageImpl{start=" + this.start + ", total=" + this.total + ", maxResults=" + this.maxResults + ", isLast=" + this.isLast + ", values=" + this.values + '}';
        }
    }

    public static class Builder<T> {
        private final List<T> values;
        private Long start = 0L;
        private Integer maxResults = 0;
        private Long total = null;
        private Boolean isLast = false;

        private Builder(List<T> values) {
            this.values = (List)Preconditions.checkNotNull(values);
        }

        public Builder<T> start(Long start) {
            this.start = start;
            return this;
        }

        public Builder<T> maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder<T> total(Long total) {
            this.total = total;
            return this;
        }

        public Builder<T> isLast(Boolean isLast) {
            this.isLast = isLast;
            return this;
        }

        public Page<T> build() {
            return new PageImpl<T>(this.start, this.maxResults, this.total, this.isLast, this.values);
        }
    }
}

