/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import org.apache.commons.lang.builder.ToStringBuilder;

@ExperimentalApi
public class RapidView {
    private final Long id;
    private final String name;
    private final Long savedFilterId;
    private final String owner;
    private final boolean sprintMarkersMigrated;
    private final boolean sprintSupportEnabled;
    private final boolean showDaysInColumn;
    private final SwimlaneStrategy swimlaneStrategy;
    private final CardColorStrategy cardColorStrategy;

    private RapidView(Long id, String name, Long savedFilterId, String owner, boolean sprintMarkersMigrated, boolean sprintSupportEnabled, SwimlaneStrategy swimlaneStrategy, CardColorStrategy cardColorStrategy, boolean showDaysInColumn) {
        this.id = id;
        this.name = name;
        this.savedFilterId = savedFilterId;
        this.owner = owner;
        this.sprintMarkersMigrated = sprintMarkersMigrated;
        this.sprintSupportEnabled = sprintSupportEnabled;
        this.swimlaneStrategy = swimlaneStrategy;
        this.cardColorStrategy = cardColorStrategy;
        this.showDaysInColumn = showDaysInColumn;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getSavedFilterId() {
        return this.savedFilterId;
    }

    @Deprecated
    public String getOwner() {
        return this.owner;
    }

    @Deprecated
    public boolean isSprintMarkersMigrated() {
        return this.sprintMarkersMigrated;
    }

    public boolean isSprintSupportEnabled() {
        return this.sprintSupportEnabled;
    }

    public boolean showDaysInColumn() {
        return this.showDaysInColumn;
    }

    public SwimlaneStrategy getSwimlaneStrategy() {
        return this.swimlaneStrategy;
    }

    public CardColorStrategy getCardColorStrategy() {
        return this.cardColorStrategy;
    }

    public Type getType() {
        return this.isSprintSupportEnabled() ? Type.SCRUM : Type.KANBAN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RapidView other = (RapidView)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static RapidViewBuilder builder() {
        return new RapidViewBuilder();
    }

    public static RapidViewBuilder builder(RapidView rapidView) {
        return new RapidViewBuilder(rapidView);
    }

    public static class RapidViewBuilder {
        private Long id;
        private String name;
        private Long savedFilterId;
        private String owner;
        private boolean sprintMarkersMigrated;
        private boolean sprintSupportEnabled;
        private boolean showDaysInColumn;
        private SwimlaneStrategy swimlaneStrategy;
        private CardColorStrategy cardColorStrategy;

        public RapidViewBuilder() {
        }

        public RapidViewBuilder(RapidView rapidView) {
            this();
            this.id(rapidView.id).name(rapidView.name).savedFilterId(rapidView.savedFilterId).owner(rapidView.owner).sprintMarkersMigrated(rapidView.sprintMarkersMigrated).sprintSupportEnabled(rapidView.sprintSupportEnabled).swimlaneStrategy(rapidView.swimlaneStrategy).cardColorStrategy(rapidView.cardColorStrategy).showDaysInColumn(rapidView.showDaysInColumn);
        }

        public RapidViewBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public RapidViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RapidViewBuilder savedFilterId(Long savedFilterId) {
            this.savedFilterId = savedFilterId;
            return this;
        }

        public RapidViewBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public RapidViewBuilder sprintMarkersMigrated(boolean sprintMarkersMigrated) {
            this.sprintMarkersMigrated = sprintMarkersMigrated;
            return this;
        }

        public RapidViewBuilder sprintSupportEnabled(boolean sprintSupportEnabled) {
            this.sprintSupportEnabled = sprintSupportEnabled;
            return this;
        }

        public RapidViewBuilder showDaysInColumn(boolean showDaysInColumn) {
            this.showDaysInColumn = showDaysInColumn;
            return this;
        }

        public RapidViewBuilder swimlaneStrategy(SwimlaneStrategy swimlaneStrategy) {
            this.swimlaneStrategy = swimlaneStrategy;
            return this;
        }

        public RapidViewBuilder cardColorStrategy(CardColorStrategy cardColorStrategy) {
            this.cardColorStrategy = cardColorStrategy;
            return this;
        }

        public RapidView build() {
            return new RapidView(this.id, this.name, this.savedFilterId, this.owner, this.sprintMarkersMigrated, this.sprintSupportEnabled, this.swimlaneStrategy, this.cardColorStrategy, this.showDaysInColumn);
        }
    }

    public static enum Type {
        SCRUM,
        KANBAN;

    }
}

