define('jira/editor/util/html-browser-converter', [], function () {
    return {
        /**
         * sometimes browsers try to "fix" html markup before inserting it in to the dom.
         * eg. sometimes <!-- --!> will be changed to <!-- --> resulting in the markup following --!> become uncommented.
         * Returns browser rendered html markup.
         */
        convert: function (html) {
            if (!html) {
                return "";
            }
            try {
                const template = document.createElement('template');
                template.innerHTML = html;
                return template.innerHTML;
            } catch (e) {
                return "";
            }
        },
    }
});