define("jira/editor/ui/button-bar-decorator", [
    "jira/lib/class",
    "jquery"
], function (
    Class,
    $
) {
    var ButtonBarDecorator = Class.extend({
        init: function init() {

        },

        decorateButtonBars: function ($tabs) {
            var decorateButtonBar = function () {
                var bar = $(this);
                if (bar.find('.wiki-button-bar-content').length){
                    return; // buttons already decorated
                }
                var contentWrapper = $('<div class="wiki-button-bar-content"></div>');
                bar.wrapInner(contentWrapper);
                var tabPlaceholder = $('<div class="tabs-placeholder"></div>');
                tabPlaceholder.width($tabs.width());
                tabPlaceholder.height($tabs.height());
                bar.prepend(tabPlaceholder);
                bar.append($('<div></div>').css("clear", "both"));
            };

            $tabs.closest('.jira-wikifield').next('.wiki-button-bar').each(decorateButtonBar);
            $tabs.closest('.inline-edit-fields').nextAll('.save-options').each(decorateButtonBar);
            $tabs.prev('.sd-rte-bar').each(decorateButtonBar);
            $tabs.parent(".wiki-edit-content").siblings('.sd-rte-bar').each(decorateButtonBar);
        }
    });

    return ButtonBarDecorator;
});