define("jira/editor/converter/handlers/superscript-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/empty-handler",
    "jira/editor/converter/util/strings",
    "jira/editor/converter/factories/whitespace-extractor",
    "jquery"
], function (
    NodeHandler,
    TextHandler,
    EmptyHandler,
    Strings,
    WhitespaceExtractor,
    $
) {
    "use strict";

    /**
     * @class SuperscriptHandler
     * @extends NodeHandler
     */
    var handler = NodeHandler.extend({
        init: function SuperscriptHandler(node) {
            this.node = node;

            if ($(this.node).parents('a').is('.external-link') &&
                Strings.endsWith($(this.node).children().attr('src'), "images/icons/mail_small.gif")) {
                this.dontExpand = true;
            }
        },

        before: function () {
            return this.dontExpand ? new EmptyHandler() : TextHandler.createTextHandler('^');
        },

        after: function () {
            return this.dontExpand ? new EmptyHandler() : TextHandler.createTextHandler('^');
        }
    });
    return WhitespaceExtractor(handler);
});