define("jira/editor/converter/handlers/noformat-handler", [
    "jira/editor/converter/handlers/block-handler",
    "jira/editor/converter/handlers/text-handler"
], function (
    BlockHandler,
    TextHandler
) {
    "use strict";

    var NoformatHandler = BlockHandler.extend({

        before: function () {
            var attrs = this.attrs ? ':' + this.attrs : '';
            return TextHandler.createPreformattedTextHandler('{noformat' + attrs + '}');
        },

        after: function () {
            return TextHandler.createPreformattedTextHandler('{noformat}');
        }
    });

    return NoformatHandler;
});