define("jira/editor/converter/handlers/heading-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/empty-handler"
], function (
    NodeHandler,
    TextHandler,
    EmptyHandler
) {
    "use strict";

    /**
     * @class HeadingHandler
     * @extends NodeHandler
     */
    var HeadingHandler = NodeHandler.extend({
        init: function HeadingHandler(node) {
            this.node = node;
        },

        newLinesBefore: function () {
            return NodeHandler.singleNewLineExceptTable(this.node, true);
        },

        before: function () {
            var name = this.node.tagName;
            if (name in headingMap) {
                return TextHandler.createTextHandler(headingMap[name]);
            }
            return new EmptyHandler();
        },

        newLinesAfter: function () {
            return NodeHandler.singleNewLineExceptTable(this.node);
        }
    });

    var headingMap = {};
    headingMap['H1'] = 'h1. ';
    headingMap['H2'] = 'h2. ';
    headingMap['H3'] = 'h3. ';
    headingMap['H4'] = 'h4. ';
    headingMap['H5'] = 'h5. ';
    headingMap['H6'] = 'h6. ';

    return HeadingHandler;

});