require([
    "jquery",
    "wrm/context-path",
    "jira/ajs/ajax/smart-ajax",
    "jira/util/logger",
    "jira/util/formatter",
    "jira/editor/analytics",
    "jira/flag"
], function (
    $,
    ContextPath,
    SmartAjax,
    Logger,
    formatter,
    Analytics,
    JiraFlag
) {
    $(function () {
        document.querySelector("section.configure-admin-rte form").addEventListener("submit", function(e) {
            e.preventDefault();
        });

        if (document.querySelector("section.configure-admin-rte .third-party-warning")) {
            Analytics.sendEvent("editor.admin.configuration.third.party");
        }

        var toggle = document.getElementById("rte-switch");
        var feedback = document.querySelector("section.configure-admin-rte .rte__feedback");
        var feedbackLink = feedback.querySelector("a");

        Analytics.sendEvent("editor.admin.configuration.page.init", {currentState: toggle.checked});

        toggle.addEventListener("change", function (e) {
            var isChecked = toggle.checked;
            var apKey = $("meta[name='rte-ap-key']").attr("content");

            toggle.busy = true;
            SmartAjax.makeRequest({
                url: ContextPath() + "/rest/api/2/application-properties/" + apKey,
                type: "PUT",
                data: JSON.stringify({id: apKey, value: isChecked}),
                dataType: "json",
                contentType: "application/json"
            }).fail(function () {
                toggle.checked = !isChecked;
                JiraFlag.showErrorMsg("", formatter.I18n.getText("jira.editor.admin.couldnt.change.value"));
            }).always(function () {
                toggle.busy = false;
                toggleFeedbackLinkVisibility(toggle.checked);

                if (isChecked) {
                    Analytics.sendEvent("editor.admin.configuration.optin");
                } else {
                    Analytics.sendEvent("editor.admin.configuration.optout");
                }
                Logger.trace("rte.switched");
            });
        });

        showCollectorDialogWhenFeedbackLinkIsClicked();
        if (!toggle.checked) {
            toggleFeedbackLinkVisibility(false);
        }


        function showCollectorDialogWhenFeedbackLinkIsClicked() {
            $.ajax({
                url: "https://jira.atlassian.com/s/15111534c443916cfb27a1ea744aac6d-T/-6wau32/73002/b6b48b2829824b869586ac216d119363/2.0.22/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?locale=en-UK&collectorId=bcdc00cc",
                type: "get",
                cache: true,
                dataType: "script"
            });

            window.ATL_JQ_PAGE_PROPS = {
                "triggerFunction": function (showCollectorDialog) {
                    feedbackLink.addEventListener("click", function (e) {
                        e.preventDefault();
                        Analytics.sendEvent("editor.admin.configuration.feedback");
                        showCollectorDialog();
                    });
                }
            };
        }

        function toggleFeedbackLinkVisibility(hide) {
            const HIDDEN_CLASS = "rte__feedback_hidden";
            if (hide) {
                feedback.classList.add(HIDDEN_CLASS);
            } else {
                feedback.classList.remove(HIDDEN_CLASS);
            }
        }
    });
});