AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:undo-redo-ui","com.atlassian.jira.plugins.jira-editor-plugin:undo-redo","jquery"],function(){var d=require("jquery");var c=require("jira/editor/constants");var e=require("jira/editor/ui/undo-redo-buttons");var b=require("jira/editor/undomanager-adapter/noop-adapter");b.prototype.triggerUndo=function(){this.trigger("editor:historychanged",c.EventTypes.UNDO,c.EventSources.BUTTON,"")};b.prototype.triggerRedo=function(){this.trigger("editor:historychanged",c.EventTypes.REDO,c.EventSources.BUTTON,"")};e.prototype._clickUndo=function(){this.ui.undo.click()};e.prototype._clickRedo=function(){this.ui.redo.click()};e.prototype._isVisible=function(){return this.$el.is(":visible")};e.prototype._isUndoEnabled=function(){return !this.ui.undo.is(":disabled")};e.prototype._isRedoEnabled=function(){return !this.ui.redo.is(":disabled")};e.prototype._hasDivider=function(){return this.$el.hasClass("wiki-edit-separate-section")};function a(g){this.sandbox=sinon.sandbox.create();var f=g.find("textarea");d("#qunit-fixture").append(g);this.textarea=f;this.sandbox.spy(this.textarea,"focus");this.undoManager=new b();this.view=new e({textarea:f,undoManager:this.undoManager});this.sandbox.spy(this.undoManager,"undo");this.sandbox.spy(this.undoManager,"redo");this.sandbox.spy(this.view,"updateUI");this.view.render()}module("Undo Redo Buttons - general",{setup:function(){this.$markup=d('<div class="jira-wikifield">\n    <div>\n        <textarea></textarea>\n    </div>\n</div>\n<div class="save-options"><div class="wiki-button-bar-content">\n    <button></button>\n</div></div>');a.call(this,this.$markup)},teardown:function(){this.$markup.remove();this.sandbox.restore()}});test("Should attach buttons (create issue context)",function(){ok(this.view._isVisible())});test("Should not show divider (create issue context)",function(){ok(!this.view._hasDivider())});test("Should update UI on undo",function(){this.undoManager.triggerUndo();ok(this.view.updateUI.called,"view.updateUI should be called")});test("Should update UI on redo",function(){this.undoManager.triggerRedo();ok(this.view.updateUI.called,"view.updateUI should be called")});test("Should disable undo button when there is no undo levels",function(){this.sandbox.stub(this.undoManager,"hasUndo").returns(true);this.view.updateUI();ok(this.view._isUndoEnabled(),"undo button should be enabled");this.undoManager.hasUndo.returns(false);this.view.updateUI();ok(!this.view._isUndoEnabled(),"undo button should be disabled")});test("Should disable redo button when there is no redo levels",function(){this.sandbox.stub(this.undoManager,"hasRedo").returns(true);this.view.updateUI();ok(this.view._isRedoEnabled(),"redo button should be enabled");this.undoManager.hasRedo.returns(false);this.view.updateUI();ok(!this.view._isRedoEnabled(),"redo button should be disabled")});test("Should not undo when button is disabled",function(){this.view._clickUndo();ok(!this.undoManager.undo.called,"undoManager.undo should not be called")});test("Should undo when button is enabled",function(){this.sandbox.stub(this.undoManager,"hasUndo").returns(true);this.view.updateUI();this.view._clickUndo();ok(this.undoManager.undo.called,"undoManager.undo should be called");ok(this.textarea.focus.called,"textarea.focus should be called");this.view._clickUndo();ok(this.undoManager.undo.calledTwice,"undoManager.undo should be called twice");ok(this.textarea.focus.calledTwice,"textarea.focus should be called twice")});test("Should not redo when button is disabled",function(){this.view._clickRedo();ok(!this.undoManager.redo.called,"undoManager.redo should not be called")});test("Should redo when button is enabled",function(){this.sandbox.stub(this.undoManager,"hasRedo").returns(true);this.view.updateUI();this.view._clickRedo();ok(this.undoManager.redo.called,"undoManager.redo should be called");ok(this.textarea.focus.called,"textarea.focus should be called");this.view._clickRedo();ok(this.undoManager.redo.calledTwice,"undoManager.redo should be called twice");ok(this.textarea.focus.calledTwice,"textarea.focus should be called twice")});module("Undo Redo Buttons - add and edit comment with lock",{setup:function(){this.$markup=d('<div class="jira-wikifield">\n    <div>\n        <textarea></textarea>\n    </div>\n</div>\n<div class="save-options"><div class="wiki-button-bar-content">\n    <a>lock</a>\n    <input>\n</div></div>');a.call(this,this.$markup)},teardown:function(){this.$markup.remove();this.sandbox.restore()}});test("Should attach buttons",function(){ok(this.view._isVisible())});test("Should show divider",function(){ok(this.view._hasDivider())});module("Undo Redo Buttons - add and edit comment without lock",{setup:function(){this.$markup=d('<div class="jira-wikifield">\n    <div>\n        <textarea></textarea>\n    </div>\n</div>\n<div class="save-options"><div class="wiki-button-bar-content">\n   <input>\n</div></div>');a.call(this,this.$markup)},teardown:function(){this.$markup.remove();this.sandbox.restore()}});test("Should attach buttons",function(){ok(this.view._isVisible())});test("Should not show divider",function(){ok(!this.view._hasDivider())});module("Undo Redo Buttons - inline edit",{setup:function(){this.$markup=d('<div class="inline-edit-fields">\n    <div>\n        <textarea></textarea>\n    </div>\n</div>\n<div></div>\n<div class="save-options"><div class="wiki-button-bar-content">\n    <button></button>\n</div></div>');a.call(this,this.$markup)},teardown:function(){this.$markup.remove();this.sandbox.restore()}});test("Should attach buttons",function(){ok(this.view._isVisible())});test("Should not show divider",function(){ok(!this.view._hasDivider())})});