define("jira/editor/ui/toolbar/clear-formatting", [
    "jira/editor/analytics",
    "jira/util/logger",
    "jquery"
], function(
    Analytics,
    logger,
    $
) {
    var createButton = function (el) {
        var $removeFormat = $(el).find("a[data-operation='clear-format']").parent();
        if ($removeFormat.length === 0) {
            $(el).find('li').wrapAll('<div class="aui-dropdown2-section"></div>');
            var $removeFormat = $(el).find('li:last-child').clone().appendTo(el).wrap('<div class="aui-dropdown2-section"></div>');
            $removeFormat.find('a').attr("data-operation", "clear-format")
                .html(AJS.I18n.getText('jira.editor.toolbar.clear.formatting'));
        }
        return $removeFormat;
    };

    var operation = function(richEditor) {
        var instance = richEditor.getInstance();
        var editor = instance && instance.editor;
        if (editor && !editor.isHidden()) {
            editor.undoManager.add();
            editor.execCommand("RemoveFormat")
            logger.trace("jira.editor.operation.executed");
            Analytics.sendEvent("editor.instance.operation.clear.formatting");
            editor.undoManager.add();
        }
    };

    var init = function(richEditor) {
        $(richEditor).parents('.wiki-edit').find('div[id*="wiki-edit-dropdown2-more"] .aui-list-truncate').each(function (idx, el) {
            var $removeFormat = createButton(el);
            $removeFormat.on("click", function(e) {
                e.preventDefault();
                operation(richEditor);
            });

            richEditor.getInstance().on("tabs:changed", function(showSource) {
                $removeFormat.parent().css("display", showSource ? "none" : "block");
            });
        });
    };

    return {
        init: init
    }
});