define("jira/editor/toggle", [
    "jira/featureflags/feature-manager",
    "jira/editor/constants",
    "jira/data/cookie",
    "jquery"
], function(
    featureManager,
    Constants,
    Cookie,
    $
) {

    var isRteDefault = !featureManager.isFeatureEnabled("jira.richeditor.enable-rte.optional");

    var EDITOR_KEY = "jira.editor.user.mode";

    var Modes = Constants.Modes;

    var setMode = function(mode) {
        return editorToggle.setProperty(EDITOR_KEY, mode);
    };

    var getMode = function() {
        return editorToggle.getProperty(EDITOR_KEY, isRteDefault ? Modes.VISUAL : Modes.TEXT);
    };

    var setProperty = function(key, value) {
        if (value === Cookie.read(key)) {
            // there was concurrent update
            return new $.Deferred().resolve(value);
        }

        // using local storage helps to not write server side <conditions>
        Cookie.save(key, value);

        var result = new $.Deferred();

        editorToggle.fetchProperty(key).always(function(oldValue) {
            if (value === oldValue) {
                // there was concurrent update
                result.resolve(oldValue);
                return;
            }

            return $.ajax({
                url: AJS.contextPath() + "/rest/api/2/mypreferences?key=" + key,
                type: "PUT",
                contentType: "application/json",
                dataType: "json",
                data: JSON.stringify(value)
            }).done(result.resolve.bind(result, oldValue))
                .fail(result.resolve.bind(result, oldValue));
        });

        return result;
    };

    var getProperty = function(key, defaultValue) {
        var result = new $.Deferred();

        if (Cookie.read(key)) {
            return result.resolve(Cookie.read(key)).promise();
        }

        editorToggle.fetchProperty(key).done(function(value) {
            result.resolve(value);
        }).fail(function() {
            result.reject(defaultValue);
        });

        if (defaultValue) {
            result.always(function (value) {
                editorToggle.setProperty(key, value);
            });
        }

        return result.promise();
    };

    var fetchProperty = function(key) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/api/2/mypreferences?key=" + key,
            type: "GET",
            contentType: "application/json",
            dataType: "json"
        });
    };

    var editorToggle = {
        setProperty: setProperty,
        getProperty: getProperty,
        fetchProperty: fetchProperty,

        getMode: getMode,
        setMode: setMode
    };

    return editorToggle;
});