AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:schema"],function(){QUnit.config.testTimeout=5000;var b=require("underscore");var g=require("jira/editor/schema");var f=require("jira/editor/tinymce");var e=require("jira/editor/util/html-browser-converter");var a=["onload","onerror","onmouseover","onmouseout","onfocus","onclick","ondblclick","ondrag","onmousedown","onmousemove","onmouseup","onmousewheel","oncopy","onpaste","oncut"];module("EditorSchema - default schema",{setup:function(){this.schema=g.getSchemaFromSpec(g.getSchemaSpecBuilder().build());this.sandbox=sinon.sandbox.create();this.editor={selection:{getStart:sinon.stub(),getEnd:sinon.stub(),getNode:sinon.stub()}}},teardown:function(){this.sandbox.restore()},stubDomParser:function(h){const i=sinon.stub().returns(h);this.sandbox.stub(f.html,"DomParser",function(){this.parse=i});return i},stubSerializer:function(){const h=sinon.stub();this.sandbox.stub(f.html,"Serializer",function(){this.serialize=h});return h},});c();test("Should allow contenteditable attribute",function(h){h.ok(d("div",["contenteditable"],this.schema))});test("Should allow <samp> tag (inline code, monospace)",function(h){h.ok(d("samp",[],this.schema),"samp without attributes");h.ok(this.schema.isValidChild("p","samp"),"<samp> should be allowed inside <p>")});test("Should convert html code to browser html before sanitizing",function(h){const i="toSanitize";this.sandbox.stub(e,"convert").returns("htmlSanitized");this.sandbox.stub(g,"getSchemaFromSpec").returns({});const k=this.stubDomParser("parsedDomNode");const j=this.stubSerializer();g.sanitizeHtml(i,this.editor);sinon.assert.calledWithExactly(e.convert,"toSanitize");sinon.assert.calledWithExactly(k,"htmlSanitized",{forced_root_block:undefined});sinon.assert.calledWithExactly(j,"parsedDomNode")});module("EditorSchema - paste schema",{setup:function(){this.schema=g.getSchemaFromSpec(g.getPasteSchemaSpecBuilder().build())}});c();test("Should not allow contenteditable attribute",function(h){h.ok(!d("div",["contenteditable"],this.schema))});module("EditorSchema - schema for pre",{setup:function(){this.schema=g.getSchemaFromSpec(g.getPasteInsidePreSchemaSpecBuilder().build())}});test("Should allow some tags but without 'style' attribute",function(){var h=["br","span","p"];h.forEach(function(i){ok(this.schema.isValid(i),"Should allow '"+i+"' tag");ok(!d(i,["style"],this.schema),"Should not allow 'style' attribute for "+i)}.bind(this));ok(this.schema.isValidChild("span","#text"),"'#text' node should be allowed inside <span>");ok(this.schema.isValidChild("p","#text"),"'#text' node should be allowed inside <p>")});test("Should not allow unsupported tags",function(h){var i=["div","panel-title","table","b","strong","sup","sub","img","tt","samp","del","cite","h1","applet","basefont","audio","canvas","command","dialog","embed","iframe","noframes","script","noscript","object","picture","summary","time","video","wbr"];i.forEach(function(j){h.ok(!this.schema.isValid(j),"Should not allow '"+j+"' tag")}.bind(this))});function c(){test("Schema should be created",function(h){h.ok(this.schema)});test("Should not allow explicit <body>",function(h){h.ok(!this.schema.isValid("body"),"body element");h.ok(!d("body",[],this.schema),"body without attributes");h.ok(!d("body",["onload"],this.schema),"body with onload attribute")});test("Should not allow <a> with event handlers",function(h){a.forEach(function(i){h.ok(!this.schema.isValid("a",i),i)}.bind(this))});test("Should allow <a> with attributes",function(h){h.ok(d("a",["href","title","target","rel","name"],this.schema))});test("Should not allow <img> with event handlers",function(h){a.forEach(function(i){h.ok(!this.schema.isValid("img",i),i)}.bind(this))});test("Should not allow <img> without attributes",function(h){h.ok(!d("img",[],this.schema))});test("Should allow <img> with src specified",function(h){h.ok(d("img",["src"],this.schema))});test("Should allow <img> with attributes",function(h){h.ok(d("img",["src","class","height","width","align","alt","border"],this.schema))});test("Should allow <img> inside <span>",function(h){h.ok(this.schema.isValidChild("span","img"))});test("Should allow headings",function(h){var i=["h1","h2","h3","h4","h5","h6"];i.forEach(function(j){h.ok(this.schema.isValid(j),"Should allow '"+j+"' tag")}.bind(this))});test("Should not allow unsupported tags",function(h){var i=["applet","basefont","audio","canvas","command","dialog","embed","iframe","noframes","script","noscript","object","picture","summary","time","video","wbr"];i.forEach(function(j){h.ok(!this.schema.isValid(j),"Should not allow '"+j+"' tag")}.bind(this))});test("Should allow tables",function(h){h.ok(d("table",["class"],this.schema));h.ok(d("td",["class"],this.schema))});test("Should not allow nested tables",function(h){h.ok(!this.schema.isValidChild("td","table"));h.ok(!this.schema.isValidChild("th","table"))});test("Should not allow paragraph inside table cells",function(h){h.ok(!this.schema.isValidChild("td","p"));h.ok(!this.schema.isValidChild("th","p"))});test("Should allow panels",function(h){h.ok(d("div",["class","style"],this.schema));h.ok(d("div",["class"],this.schema));h.ok(d("div",[],this.schema))});test("Should not allow forms",function(h){["form","input","select"].forEach(function(i){h.ok(!this.schema.isValid(i),i)}.bind(this))});test("Should support custom element",function(h){var i="panel-title";ok(this.schema.isValid(i),i);ok(this.schema.isValidChild(i,"#text"));ok(this.schema.isValidChild(i,"span"));["h2","b","strong","p","div","u","em","table","img","br"].forEach(function(j){h.ok(!this.schema.isValidChild(i,j),"Should not allow '"+j+"' inside <"+i+">")}.bind(this))});test("Should allow only new lines, span and #text in <pre>",function(h){ok(this.schema.isValidChild("pre","br"),"Should allow <br> inside <pre>");ok(this.schema.isValidChild("pre","#text"),"Should allow #text inside <pre>");ok(this.schema.isValidChild("pre","span"),"Should allow <span> inside <pre>");ok(this.schema.isValidChild("pre","pre"),"Should allow <pre> inside <pre>");ok(this.schema.isValidChild("pre","panel-title"),"Should allow <panel-title> inside <pre>");["h2","b","strong","div","ins","u","em","i","table","img"].forEach(function(i){h.ok(!this.schema.isValidChild("pre",i),"Should not allow '"+i+"' inside <pre>")}.bind(this))})}function d(i,h,j){if(!j.isValid(i)){return false}var k=j.getElementRule(i);return(0===b.difference(h,Object.keys(k.attributes)).length&&0===b.difference(k.attributesRequired,h).length)}});