AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    var RteStrings = require('jira/editor/converter/util/rte-strings');

    module('RteStrings');

    test('Test isWhitespace nulls', function() {
        equal(RteStrings.isWhitespace(null), false);
    });

    test('Test whitespace characters', function() {
        ok(RteStrings.isWhitespace('\n'), 'Test Newline');
        ok(RteStrings.isWhitespace('\t'), 'Test Tab');
        ok(RteStrings.isWhitespace('\u0020'), 'HTML 4.0 ascii space');
        ok(RteStrings.isWhitespace('\u0009'), 'HTML 4.0 ascii tab');
        ok(RteStrings.isWhitespace('\u000C'), 'HTML 4.0 ascii form feed');
        ok(RteStrings.isWhitespace('\u200B'), 'HTML 4.0 ascii zero-width space');
        ok(RteStrings.isWhitespace('\u000D'), 'HTML 4.0 a carriage return');
        ok(RteStrings.isWhitespace('\u000A'), 'HTML 4.0 a line feed');
    });

    test('Trim Leading whitespaces', function() {
        equal(RteStrings.trimLeading("test"), "test", "Should be the same string");
        equal(RteStrings.trimLeading("   test"), "test", "Whitespace characters has to be trimmed");
        equal(RteStrings.trimLeading("\n\n\n   test"), "test", "Whitespace characters has to be trimmed");
        equal(RteStrings.trimLeading("   \n\n\ntest"), "test", "Whitespace characters has to be trimmed");
    });

    test('Trim Trailing whitespaces', function() {
        equal(RteStrings.trimTrailing("test"), "test", "Should be the same string");
        equal(RteStrings.trimTrailing("test   "), "test", "Whitespace characters has to be trimmed");
        equal(RteStrings.trimTrailing("test\n\n\n   "), "test", "Whitespace characters has to be trimmed");
        equal(RteStrings.trimTrailing("test   \n\n\n"), "test", "Whitespace characters has to be trimmed");
    });

    test('Trim all whitespaces', function() {
        equal(RteStrings.trim("test"), "test", "Should be the same string");
        equal(RteStrings.trim("   test   "), "test", "Whitespace characters has to be trimmed");
        equal(RteStrings.trim("\n\n\n   test\n\n\n   "), "test", "Whitespace characters has to be trimmed");
        equal(RteStrings.trim("   \n\n\ntest   \n\n\n"), "test", "Whitespace characters has to be trimmed");
    });
});