/**
 * Handle new lines creation in RTE editor.
 *
 * Handler can be optional: optional handler doesn't add additional lines if there are enough lines created
 *
 * Final number of new lines is maximum value from
 * - sum of all new lines before/after non-optional nodes
 * - maximum value of all optional newline handlers
 *
 * New lines are added after/before NodeHandler#after/NodeHandler#before function
 *
 * @module jira/editor/converter/new-lines/new-lines
 */
define('jira/editor/converter/new-lines/new-lines', [
    "jira/lib/class"
], function (
    Class
) {
    var NewLines = Class.extend({
        init: function (lines, optional) {
            this._lines = lines;
            this._optional = optional;
        },

        newLines: function () {
            return this._lines;
        },

        optional: function () {
            return this._optional;
        }
    });

    NewLines.empty = function () {
        return new NewLines(0, true);
    };

    NewLines.single = function (optional) {
        return new NewLines(1, !!optional);
    };

    return NewLines;
});


