/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.editor.render;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.editor.service.JiraRteEnabledService;
import com.atlassian.jira.plugin.renderer.MacroModuleDescriptor;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.MacroRendererComponent;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class VisualMacroRendererComponent
extends MacroRendererComponent {
    private static final String MODULE_KEY = "com.atlassian.jira.plugins.jira-editor-plugin:renderer";
    private static final String TEMPLATE_NAME = "JIRA.Editor.RendererComponentDecorator.macro";
    private final JiraRteEnabledService rteEnabledService;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;

    public VisualMacroRendererComponent(MacroManager macroManager, JiraRteEnabledService rteEnabledService, SoyTemplateRendererProvider soyTemplateRendererProvider) {
        super(macroManager, (SubRenderer)ComponentAccessor.getComponent(SubRenderer.class));
        this.rteEnabledService = rteEnabledService;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    public void makeMacro(StringBuffer buffer, MacroTag startTag, String body, RenderContext context) {
        if (Boolean.TRUE.equals(context.getParam((Object)"atlassian-renderer-for-wysiwyg")) && (this.isUnsupported(startTag.command) || this.rteEnabledService.isLegacyMacroEnforced())) {
            buffer.append(context.addRenderedContent((Object)this.soyTemplateRendererProvider.getRenderer().render(MODULE_KEY, TEMPLATE_NAME, (Map)ImmutableMap.of((Object)"newLineBefore", (Object)startTag.isNewlineBefore(), (Object)"newLineAfter", (Object)startTag.isNewlineAfter(), (Object)"originalText", (Object)startTag.originalText, (Object)"body", (Object)body, (Object)"command", (Object)startTag.command))));
        } else {
            super.makeMacro(buffer, startTag, body, context);
        }
    }

    private boolean isUnsupported(String name) {
        return this.rteEnabledService.getModuleDescriptors(MacroModuleDescriptor.class).filter(descriptor -> name.equals(descriptor.getKey())).anyMatch(this.rteEnabledService::isUnsupported);
    }
}

