Backbone.define('JIRA.DevStatus.ReviewView', JIRA.DevStatus.BaseSummaryView.extend({
    template: JIRA.Templates.DevStatus.Review.summaryPanel,

    _onSummaryLinkClick: function(e) {
        e.preventDefault();

        this.detailDialogReviewView = new JIRA.DevStatus.DetailDialogReviewView(
            _.extend(this.getDefaultDetailDialogParameters(), {
                id: "devstatus-review-detail-dialog",
                count: this.model.getOverall().count,
                reviewersThreshold: 2
            }));
        JIRA.DevStatus.ReviewsAnalytics.fireSummaryClickedEvent(this.options.analyticsModel.getSummary());
        this.detailDialogReviewView.show();
    }
}));
