AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-review-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");

(function() {
    module("JIRA.DevStatus.ReviewView", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.server = sinon.fakeServer.create();
            this.fixture = jQuery("#qunit-fixture");
            this.statusPanel = jQuery('<div></div>').appendTo(this.fixture)

            JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Reviews", this.sandbox);
            JIRA.DevStatus.ReviewsAnalytics.fireSummaryShownEvent = sinon.spy();
            JIRA.DevStatus.ReviewsAnalytics.fireSummaryClickedEvent = sinon.spy();
        },
        teardown : function () {
            this.sandbox.restore();
            this.server.restore();
            JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();
        },
        createView: function(data, expectVisible) {
            expectVisible = typeof expectVisible !== "undefined" ? expectVisible : true;
            var model = new JIRA.DevStatus.MockSummaryModel();
            model.getOverall.returns(data);
            var view = new JIRA.DevStatus.ReviewView({
                model: model,
                el: this.statusPanel,
                livestampRelativizeThreshold: 3600,
                analyticsModel: {
                    getIssue: sinon.stub(),
                    getSummary: sinon.stub().returns({unicorn:"awesome"})
                }
            });
            view.render();
            if (expectVisible) {
                ok(this.statusPanel.html(), "content is rendered");
                ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
            }
        },
        reviewData: function(count, state, stateCount, dueDate, lastUpdated, overDue) {
            return {
                count: count,
                // We can assume this will be done from server
                state: state && state.toUpperCase(),
                stateCount: stateCount,
                dueDate: dueDate || null,
                lastUpdated: lastUpdated || null,
                overDue: overDue || false
            };
        }
    });

    test("render with no reviews", function() {
        this.createView({count: 0}, false);
        ok(!this.statusPanel.html(), "content is empty");
        ok(this.statusPanel.hasClass("hidden"), "panel is hidden");
    });

    test("render with single review", function() {
        this.createView(this.reviewData(1, 'Review', 1, '2013-11-06T14:13:42.246+0100'));
        equal(this.statusPanel.find('.count').text(), '1', "review count shown");
        equal(this.statusPanel.find('.summary').text(), '1 review', "review message shown");
        equal(this.statusPanel.find('.aui-lozenge').text(), 'Review', "review state shown");
        ok(this.statusPanel.find('time').length, 'timestamp rendered');
        ok(this.statusPanel.find('.sub-text').text().indexOf('Due') == 0, 'Due date shown');
        ok(!this.statusPanel.find('.sub-text.overdue').length, 'review is not rendered as overdue');
    });

    test("render overdue review", function() {
        this.createView(this.reviewData(1, 'Review', 1, '2013-11-06T14:13:42.246+0100', null, true));
        ok(this.statusPanel.find('.sub-text.overdue').length, 'review rendered as overdue');
    });

    test("render with single review and no due date", function() {
        this.createView(this.reviewData(1, 'Approval', 1, null, '2013-11-06T14:13:42.246+0100'));
        equal(this.statusPanel.find('.count').text(), '1', "review count shown");
        equal(this.statusPanel.find('.summary').text(), '1 review', "review message shown");
        equal(this.statusPanel.find('.aui-lozenge').text(), 'Approval', "review state shown");
        ok(this.statusPanel.find('time').length, 'timestamp rendered');
        ok(this.statusPanel.find('.sub-text').text().indexOf('Updated') == 0, 'last update date shown');
    });

    test("render with single review no date", function() {
        this.createView(this.reviewData(1, 'Summarize', 1));
        equal(this.statusPanel.find('.count').text(), '1', "review count shown");
        equal(this.statusPanel.find('.summary').text(), '1 review', "review message shown");
        equal(this.statusPanel.find('.aui-lozenge').text(), 'Summarize', "review state shown");
        ok(!this.statusPanel.find('time').length, 'timestamp not rendered');
    });

    test("render with multiple reviews in different states", function() {
        this.createView(this.reviewData(3, 'Closed', 2, '2013-11-06T14:13:42.246+0100'));
        equal(this.statusPanel.find('.count').text(), '2', "review count shown");
        equal(this.statusPanel.find('.summary').text(), '2 reviews', "review message shown");
        equal(this.statusPanel.find('.aui-lozenge').text(), 'Closed', "review state shown");
        ok(this.statusPanel.find('time').length, 'timestamp rendered')
    });

    test("render with multiple reviews in same state", function() {
        this.createView(this.reviewData(3, 'Rejected', 3, '2013-11-06T14:13:42.246+0100'));
        equal(this.statusPanel.find('.count').text(), '3', "review count shown");
        equal(this.statusPanel.find('.summary').text(), '3 reviews', "review message shown");
        equal(this.statusPanel.find('.aui-lozenge').text(), 'Rejected', "review state shown");
        ok(this.statusPanel.find('time').length, 'timestamp rendered')
    });

    test("event is sent when the summary link is clicked", function() {
        this.createView(this.reviewData(10, 'Summarize', 1));

        this.statusPanel.find(".summary").click();
        equal(JIRA.DevStatus.ReviewsAnalytics.fireSummaryClickedEvent.callCount, 1);
        ok(JIRA.DevStatus.ReviewsAnalytics.fireSummaryClickedEvent.getCall(0).calledWith({unicorn: "awesome"}));
    });

})();
