AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-deployment-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");

(function() {
    module("JIRA.DevStatus.DeploymentView", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            //Tests will attempt to make an ajax call to JIRA which will redirect to the login page
            //This will stop that from happening.
            this.server = sinon.fakeServer.create();
            this.fixture = jQuery("#qunit-fixture");
            this.statusPanel = jQuery('<div></div>').appendTo(this.fixture);
            JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Deployments", this.sandbox);

            this.livestamp = jQuery.fn.livestamp;
            jQuery.fn.livestamp = sinon.spy();
        },
        teardown : function () {
            this.sandbox.restore();
            this.server.restore();
            // close dialogs
            JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();
            //JIRA form dialog appends overflow: hidden to the body of the page. This is to remove it.
            AJS.$("body").css("overflow", "initial");

            jQuery.fn.livestamp = this.livestamp;
        },
        createView: function(data) {
            var model = new JIRA.DevStatus.MockSummaryModel();
            model.getOverall.returns(data);
            var analyticsModel = {
                getIssue: sinon.stub(),
                getSummary: sinon.stub().returns({unicorn: "awesome"})
            };
            this.view = new JIRA.DevStatus.DeploymentView({
                                                                model: model,
                                                                el: this.statusPanel,
                                                                livestampRelativizeThreshold: 3600,
                                                                analyticsModel: analyticsModel
                                                            });
        }
    });

    test("not show panel", function() {
        this.createView({count: 0});
        this.view.render();
        ok(!this.statusPanel.html(), "content is not rendered");
        ok(this.statusPanel.hasClass("hidden"), "panel is hidden");

        this.statusPanel.find(".summary").click();
    });

    test("render and show panel", function() {
        this.createView({count: 1, lastUpdated: null, showProjects: false, successfulCount: 1, topEnvironments: [{title: "Name", id: "1", url: "http://environmentUrl", project: "projectName", projectId: "1", projectUrl: "http://projectUrl"}]});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".environment").text(), "Name", "Environment is displayed");
        this.statusPanel.find(".summary").click();
    });

    test("not all environments shown", function() {
        this.createView({count: 1, lastUpdated: null, showProjects: false, successfulCount: 4,
                            topEnvironments: [{title: "Name", id: "1", url: "http://environmentUrl", project: "projectName", projectId: "1", projectUrl: "http://projectUrl"},
                                {title: "Name2", id: "2", url: "http://environmentUrl2", project: "projectName", projectId: "1", projectUrl: "http://projectUrl"},
                                {title: "Name3", id: "3", url: "http://environmentUrl3", project: "projectName", projectId: "1", projectUrl: "http://projectUrl"}]});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".environment:first").text(), "Name", "Environment is displayed");
        equal(this.statusPanel.find(".environment:last").text(), "Name3", "Environment is displayed");
        ok(this.statusPanel.find(".summary-content").text().indexOf(" and 1 more") !== -1, "Remaining counters are correct");
        this.statusPanel.find(".summary").click();
    });

    test("project names shown if necessary", function() {
        this.createView({count: 1, lastUpdated: null, showProjects: true, successfulCount: 123,
                            topEnvironments: [{title: "Name", id: "1", url: "http://environmentUrl", project: "projectName", projectId: "1", projectUrl: "http://projectUrl"},
                                {title: "Name2", id: "2", url: "http://environmentUrl2", project: "projectName2", projectId: "2", projectUrl: "http://projectUrl2"},
                                {title: "Name3", id: "3", url: "http://environmentUrl3", project: "projectName2", projectId: "2", projectUrl: "http://projectUrl2"}]});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");

        $envDiv = this.statusPanel.find(".environment:first");
        equal($envDiv.attr("title"), "Project: projectName", "Project link is displayed");
        equal($envDiv.text(), "Name", "Environment is displayed");

        $envDiv = this.statusPanel.find(".environment:last");
        equal($envDiv.attr("title"), "Project: projectName2", "Second project link is displayed");
        equal($envDiv.text(), "Name3", "Third environment is displayed");

        ok(this.statusPanel.find(".summary-content").text().indexOf(" and 120 more") !== -1, "Remaining counters are correct");
        this.statusPanel.find(".summary").click();
    });

    test("not deployed", function() {
        this.createView({count: 1, lastUpdated: null, showProjects: false, successfulCount: 0,
                            topEnvironments: []});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.text(), "No deployments contain latest commits", "'no deployments' text shown");
        this.statusPanel.find(".summary").click();
    });

    test("event is sent when the summary link is clicked", function() {
        this.createView({count: 1, lastUpdated: null, showProjects: false, successfulCount: 1, topEnvironments: [{title: "Name", id: "1", url: "http://environmentUrl", project: "projectName", projectId: "1", projectUrl: "http://projectUrl"}]});
        this.view.render();

        this.statusPanel.find(".summary").click();
        equal(JIRA.DevStatus.DeploymentsAnalytics.fireSummaryClickedEvent.callCount, 1);
        ok(JIRA.DevStatus.DeploymentsAnalytics.fireSummaryClickedEvent.getCall(0).calledWith({unicorn: "awesome"}));
        JIRA.DevStatus.DeploymentsAnalytics.fireSummaryClickedEvent.reset();
    });

})();
