AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-commit-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");

(function() {

    module("JIRA.DevStatus.CommitView", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.server = sinon.fakeServer.create();
            this.fixture = jQuery("#qunit-fixture");
            this.createPanel();
            this.livestamp = jQuery.fn.livestamp;
            this.commitStatusPanel = jQuery('<div id="commit-status-panel" data-issue-type="bug" '
                  + 'data-issue-status="in-progress" data-is-assignee="true">'
                  + '<a href="#" class="summary-commit">'
                  + '<time class="livestamp">XX</time></div>').appendTo(this.fixture);
            jQuery.fn.livestamp = sinon.spy();
            JIRA.DevStatus.SummaryAnalytics.fireSummaryShownEvent = this.sandbox.spy();
            JIRA.DevStatus.CommitsAnalytics.fireSummaryClickedEvent = this.sandbox.spy();
        },
        teardown : function () {
            this.sandbox.restore();
            this.server.restore();
            jQuery.fn.livestamp = this.livestamp;
            JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();
            //JIRA form dialog appends overflow: hidden to the body of the page. This is to remove it.
            AJS.$("body").css("overflow", "initial");
        },
        createPanel: function() {
            this.statusPanel = jQuery('<div class="status-panel hidden" id="commit-status-panel">').appendTo(this.fixture);
        },
        createModel: function() {
            return new JIRA.DevStatus.MockSummaryModel();
        }
    });

    test("render and show panel", function() {
        var model = this.createModel();
        model.getOverall.returns({count: 1, lastUpdated:'2013-07-23T11:03:06.000+1000'});
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        var analyticsModel = {
            getSummary: sinon.stub().returns({pokemon: true})
        };
        var view = new JIRA.DevStatus.CommitView({
            model: model,
            el: this.statusPanel,
            livestampRelativizeThreshold: 3600,
            analyticsModel: analyticsModel
        });
        view.render();
        ok(this.statusPanel.html(), "content is rendered");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2013-07-23");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");

        this.statusPanel.find(".summary").click();
        ok(_.isObject(view.detailDialogCommitView), "DetailDialogCommitView is created when the link is clicked");
    });

    test("not show panel", function() {
        var model = this.createModel();
        model.getOverall.returns({count: 0});
        var view = new JIRA.DevStatus.CommitView({
            model: model,
            el: this.statusPanel,
            livestampRelativizeThreshold: 3600
        });
        view.render();
        ok(!this.statusPanel.html(), "content is not rendered");
        ok(this.statusPanel.hasClass("hidden"), "panel is hidden");

        this.statusPanel.find(".summary-commit").click();
        ok(!_.isObject(view.detailDialogCommitView), "DetailDialogCommitView is not created when link doesn't exist");
    });

    test("Event is sent when the summary link is clicked", function() {
        var analyticsModel = {
            getSummary: sinon.stub().returns({commit: true, branch: false, build: true})
        };
        var commitModule = new JIRA.DevStatus.CommitModule({
            devStatusData: this.devStatusData,
            livestampRelativizeThreshold: this.livestampRelativizeThreshold,
            el: this.commitStatusPanel,
            analyticsModel: analyticsModel
        });
        commitModule.render({ summary : {
            "repository" : {
                overall : {
                    "commits":["abcd1234"],
                    "count":1,
                    "lastUpdated":'2013-07-23T11:03:06.000+1000'
                }
            }
        }});

        this.commitStatusPanel.find(".summary").click();
        ok(JIRA.DevStatus.CommitsAnalytics.fireSummaryClickedEvent.called);
        ok(JIRA.DevStatus.CommitsAnalytics.fireSummaryClickedEvent.calledWith({commit: true, branch: false, build: true}));
    });

})();
