AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");

(function() {

    module("JIRA.DevStatus.SummaryErrorModel", {
        assertInstances: function(actualInstances, instances, msgPrefix) {
            equal(actualInstances.length, instances.length, msgPrefix + " has correct number of instances");
            _.each(_.zip(actualInstances, instances), function(pair, index) {
                deepEqual(pair[0], pair[1], msgPrefix + " instance " + index + " is different");
            });
        },
        assertModel: function(model, hasErrors, instances, msgPrefix) {
            equal(model.get("hasErrors"), hasErrors, msgPrefix + " has correct hasErrors");
            this.assertInstances(model.get("errorInstances"), instances, msgPrefix)
        }
    });

    test("extractErrors: no error with null input", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors();
        equal(instances.length, 0, "returns empty instances");
    });

    test("extractErrors: no error with empty input", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors({});
        equal(instances.length, 0, "returns empty instances");
    });

    test("extractErrors: no error in input", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors([
            { instance: {name: "name 1", baseUrl: "#"}, data: {}},
            { instance: {name: "name 2", baseUrl: "#"}, data: {}}
        ]);
        equal(instances.length, 0, "returns empty instances");
    });

    test("extractErrors: error at the beginning", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors([
            { instance: {name: "name e", baseUrl: "#"}, error: "e"},
            { instance: {name: "name 1", baseUrl: "#"}, data: {}},
            { instance: {name: "name 2", baseUrl: "#"}, data: {}}
        ]);
        this.assertInstances(instances, [{name: "name e", baseUrl: "#"}], "1 error: ");
    });

    test("extractErrors: error in the middle", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors([
            { instance: {name: "name 1", baseUrl: "#"}, data: {}},
            { instance: {name: "name e", baseUrl: "#"}, error: "e"},
            { instance: {name: "name 2", baseUrl: "#"}, data: {}}
        ]);
        this.assertInstances(instances, [{name: "name e", baseUrl: "#"}], "1 error: ");
    });

    test("extractErrors: error at the end", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors([
            { instance: {name: "name 1", baseUrl: "#"}, data: {}},
            { instance: {name: "name 2", baseUrl: "#"}, data: {}},
            { instance: {name: "name e", baseUrl: "#"}, error: "e"}
        ]);
        this.assertInstances(instances, [{name: "name e", baseUrl: "#"}], "1 error: ");
    });

    test("extractErrors: multiple errors", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        var instances = model._extractErrors([
            { instance: {name: "name 1", baseUrl: "#"}, data: {}},
            { instance: {name: "name e1", baseUrl: "#"}, error: "e"},
            { instance: {name: "name e2", baseUrl: "#"}, error: "e"},
            { instance: {name: "name 2", baseUrl: "#"}, data: {}},
            { instance: {name: "name e3", baseUrl: "#"}, error: "e"}
        ]);
        this.assertInstances(instances, [{name: "name e1", baseUrl: "#"}, {name: "name e2", baseUrl: "#"}, {name: "name e3", baseUrl: "#"}], "3 error: ");
    });

    test("updateData: no error", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        model._extractErrors = sinon.stub();
        model._extractErrors.returns([]);
        model.updateData();
        this.assertModel(model, true, [], "model");
    });

    test("updateData: error with 1 instance", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        model._extractErrors = sinon.stub();
        var instances = [
            {name: "name e", baseUrl: "#"}
        ];
        model._extractErrors.returns(instances);
        model.updateData(instances);
        this.assertModel(model, true, instances, "model");
    });

    test("updateData: error with 3 instances", function() {
        var model = new JIRA.DevStatus.SummaryErrorModel({});
        model._extractErrors = sinon.stub();
        var instances = [
            {name: "name e1", baseUrl: "#"},
            {name: "name e2", baseUrl: "#"},
            {name: "name e3", baseUrl: "#"}
        ];
        model._extractErrors.returns(instances);
        model.updateData(instances);
        this.assertModel(model, true, instances, "model");
    });

})();
