//noinspection JSUnusedGlobalSymbols
/**
 * A base implementation for modules of summary panels and the error panel.
 *
 * @class JIRA.DevStatus.BasePanelModule
 * @extends Backbone.Model
 */
Backbone.define('JIRA.DevStatus.BasePanelModule', Backbone.Model.extend({

    initialize: function (options) {
        this.options = _.defaults({}, options);
        this.data = this.createModel();
    },

    /**
     * Renders the aggregated data. If aggregated data is not provided, renders nothing.
     * @param data Aggregated data. Undefined if there was an error in getting data.
     */
    render: function (data) {
        this.startViews();
        this.data.updateData(data);
        this.view.render();
    },

    /**
     * Sets this module's loading status.
     */
    startLoading: function() {
        this.data.startLoadingData && this.data.startLoadingData();
    },

    /**
     * Initialises this module's views.
     */
    startViews: function() {
        if (!this.view) {
            this.view = this.createView();
        }
    },

    /**
     * Stops this module's views.
     */
    stopViews: function() {
        if (this.view) {
            this.view.undelegateEvents();
            this.view.$el.empty();
            this.view.hide();
            this.view = null;
        }
    },

    isViewVisible: function() {
        return this.view && this.view.isVisible();
    },

    // ==== to be implemented by sub-classes ===
    /**
     * Create a view specific to the implementation of the sub-module.
     */
    createView: function() {},

    /**
     * Create a model specific to the implementation of the sub-module.
     * The model created should support a updateData(data) method that
     *  updates the data into its internal properties to be used for rendering the view later.
     */
    createModel: function() {}
}));
