/**
 * View for the "Try labs" link. This is just an inconspicuous link allows you to "un-dismiss" the LabsOptInView.
 *
 * @type JIRA.DevStatus.Labs.TryLabsView
 */
Backbone.define("JIRA.DevStatus.Labs.TryLabsView", Backbone.View.extend({
    events: {
        "click .try-labs": "_onClickTryLabs"
    },

    /**
     * Creates a new LabsOptInView.
     *
     * @param options
     * @param options.labsOptIn {JIRA.DevStatus.Labs.LabsOptInModel}
     */
    initialize: function(options) {
        this.labsOptIn = options.labsOptIn;
        this.labsOptIn.on("change:dismissed", this.render, this);
    },

    render: function() {
        // only show the Try Labs span when labs is allowed, user has not opted in and info is dismissed
        if (!this.labsOptIn.isAllowed() || this.labsOptIn.isOptedIn() || !this.labsOptIn.isDismissed()) {
            this.$el.empty();
        } else {
            this.$el.html(JIRA.Templates.DevStatus.tryLabs());
        }

        return this;
    },

    /**
     * Resets the LabsOptInModel's dismissed state.
     *
     * @returns {*}
     * @private
     */
    _onClickTryLabs: function(e) {
        e.preventDefault();
        this.labsOptIn.setDismissed(false);
    }

}));
