AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");

module("JIRA.DevStatus.Labs.LabsOptInView", {
    setup: function() {
        this.sandbox = sinon.sandbox.create();
        this.fixture = jQuery("#qunit-fixture");
        this.jiraIssue = JIRA.Issue;
    },

    teardown: function() {
        this.sandbox.restore();
        JIRA.Issue = this.jiraIssue;
    },

    initLabsOptInView: function(opts) {
        var defaults = {
            allowed: true,
            optedIn: false,
            optedInByAdmin: false,
            dismissed: false,
            issueKey: "TEST-1"
        };
        opts = jQuery.extend(defaults, opts);

        this.labsOptIn = jQuery.extend(new Backbone.Model(), {
            _dismissed: false,

            isAllowed: sinon.stub().withArgs(null),
            isOptedIn: sinon.stub().withArgs(null),
            isOptedInByAdmin: sinon.stub().withArgs(null),
            toggleOptedIn: sinon.stub().withArgs(null),
            isDismissed: sinon.stub().withArgs(null),
            setDismissed: sinon.stub()
        });

        this.labsOptIn.isAllowed.returns(opts.allowed);
        this.labsOptIn.isOptedIn.returns(opts.optedIn);
        this.labsOptIn.isOptedInByAdmin.returns(opts.optedInByAdmin);
        this.labsOptIn.toggleOptedIn.returns(new jQuery.Deferred().resolve());
        this.labsOptIn.isDismissed.returns(opts.dismissed);

        this.fixture.empty();
        this.panel = jQuery("<div></div>").appendTo(this.fixture);

        JIRA.Issue = JIRA.Issue || {};
        JIRA.Issue.getIssueKey = this.sandbox.stub().withArgs(null);
        JIRA.Issue.getIssueKey.returns(opts.issueKey);

        this.labsOptInView = new JIRA.DevStatus.Labs.LabsOptInView({ el: this.panel, labsOptIn: this.labsOptIn }).render();
    },

    clickToggleLabs: function() {
        this.fixture.find('.toggle-labs').trigger(jQuery.Event("click"));
    }
});

test("All users see the labs on/off panel when dark feature is on.", function() {
    var instance = this;
    var toggleCase = [true, false];
    _.each(toggleCase, function(allowed) {
        _.each(toggleCase, function(optedInByAdmin) {
            _.each(toggleCase, function(optedIn) {
                _.each(toggleCase, function(dismissed) {
                    var config = {
                        allowed: allowed,
                        optedIn: optedIn,
                        optedInByAdmin: optedInByAdmin,
                        dismissed: dismissed
                    };
                    config.toString = function() { return JSON.stringify(config); };

                    instance.initLabsOptInView(config);

                    var onOffPanel = instance.fixture.find('div.on-off-panel');
                    var panelShown = onOffPanel.length == 1 && !instance.panel.hasClass("hidden");
                    var panelHidden = onOffPanel.length == 0 && instance.panel.hasClass("hidden");

                    if (allowed && optedInByAdmin) {
                        ok(panelShown, "Panel is shown when admin opts everyone in " + config);
                        ok(onOffPanel.find('.disable-labs').length == 0, "Disable link is not shown " + config)
                    }
                    else if (!allowed || dismissed) {
                        ok(panelHidden, "Panel is not shown when Labs not allowed or panel has been dismissed " + config);
                    } else {
                        ok(panelShown, "Panel is shown in all other situations " + config);
                    }
                });
            });
        });
    });
});

test("Any user can turn on/off dark feature", function() {
    this.initLabsOptInView({ optedIn: false });
    this.clickToggleLabs();
    ok(this.labsOptIn.toggleOptedIn.called, "LabsOptInModel.toggleOptedIn() should be called");

    this.initLabsOptInView({ optedIn: true });
    this.clickToggleLabs();
    ok(this.labsOptIn.toggleOptedIn.called, "LabsOptinModel.toggleOptedIn() should be called");
});

test("Collapsing and reopening the info panel", function() {
    this.initLabsOptInView();
    equal(this.fixture.find('.title').text(), "JIRA Labs", "Info panel should be expanded");

    this.fixture.find('.labs-close').trigger(jQuery.Event("click"));
    ok(this.labsOptIn.setDismissed.called, "LabsOptInModel.setDismissed should be called");
    this.labsOptIn.isDismissed.returns(true);
    this.labsOptIn.set('dismissed', true); // triggers change event
    equal(this.fixture.find('.title').length, 0, "LabsOptInView should be collapsed");

    this.fixture.find('.labs-open').trigger(jQuery.Event("click"));
    ok(this.labsOptIn.setDismissed.called, "LabsOptInModel.setDismissed should be called");
    this.labsOptIn.isDismissed.returns(false);
    this.labsOptIn.set('dismissed', false); // triggers change event
    equal(this.fixture.find('.title').text(), "JIRA Labs", "Info panel should be expanded again");
});

test("_showFeedbackDialog() uses the JIRA Issue Collector", JIRA.DevStatus.QunitTestUtils.withFakeTimer(function (clock) {
    this.initLabsOptInView();

    this.sandbox.stub(jQuery, "getScript");
    this.labsOptInView._showFeedbackDialog();

    // make sure things are ready for the issue collector to do its thing
    ok(window.ATL_JQ_PAGE_PROPS.effe8b72, "ATL_JQ_PAGE_PROPS are set for collector effe8b72");
    ok(window.ATL_JQ_PAGE_PROPS.effe8b72.triggerFunction, "triggerFunction should be provided");
    ok(window.ATL_JQ_PAGE_PROPS.effe8b72.fieldValues.summary, "default summary should be provided");

    // makes sure the right JS is loaded from JAC
    ok(jQuery.getScript.called, "Javascript is loaded from JAC");
    equal(jQuery.getScript.getCall(0).args[0], "https://jira.atlassian.com/s/d41d8cd98f00b204e9800998ecf8427e/en_UK-b435xk-1988229788/6144/9/1.4.0-m6/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?collectorId=effe8b72", "");

    var mockShowCallback = sinon.stub();
    window.ATL_JQ_PAGE_PROPS.effe8b72.triggerFunction(mockShowCallback);
    clock.tick(1); // needed because triggerFunction uses _.defer
    ok(mockShowCallback.called, "triggerFunction should invoke our callback to bring up the feedback dialog");
}));

test("Feedback link triggers the Feedback dialog", function() {
    this.initLabsOptInView({ optedIn: true });
    this.sandbox.stub(this.labsOptInView, "_showFeedbackDialog");

    this.fixture.find('.feedback-link').trigger(jQuery.Event("click"));
    ok(this.labsOptInView._showFeedbackDialog.called, "clicking the feedback link should trigger the feedback dialog")
});

test("Disabling labs triggers the Feedback dialog", function() {
    this.initLabsOptInView({ optedIn: true });
    this.sandbox.stub(this.labsOptInView, "_showFeedbackDialog");

    // update a model property and let Model trigger the event
    this.labsOptIn.set("optedIn", false);
    ok(this.labsOptInView._showFeedbackDialog.called, "disabling labs should trigger the feedback dialog")
});
