Backbone.define("JIRA.DevStatus.InstancePickerView", Backbone.View.extend({
    ARROW_KEY_UP_CODE: 38,
    ARROW_KEY_DOWN_CODE: 40,
    template: JIRA.Templates.DevStatus.Dialog.content,

    events: {
        'keydown .jira-dialog-content': '_onTargetKeyboardSelect',
        'focus .target': '_onTargetFocus'
    },

    initialize: function (options) {
        this.currentSelected = null;
        this.link = options.activeTrigger;
        this.cta = options.cta;
        this.processTargets = options.processTargets;

        // the function to be called when only a single result is present
        this.uniqueResultAction = options.uniqueResultAction || function(uniqueResult) {
            JIRA.DevStatus.Navigate.navigate(uniqueResult.url);
        }
    },

    render: function () {
        var issueId = this._getIssueId(this.link),
            deferred = AJS.$.Deferred();

        this._fetchTargets(this.cta, issueId).done(_.bind(function(remoteApps) {
                if (this.processTargets) {
                    remoteApps.remoteApps = this.processTargets(remoteApps.remoteApps);
                }

                var uniqueResult = this._isUniqueResult(remoteApps);
                if (uniqueResult) {
                    this.uniqueResultAction(uniqueResult);
                } else {
                    var content = AJS.$(this.template(remoteApps));
                    deferred.resolve(content);
                }
            }, this)).fail(function(errorContent) {
                deferred.resolve(errorContent);
            });
        return deferred.promise();
    },

    _fetchTargets: function (cta, issueId) {
        var deferred = AJS.$.Deferred();
        AJS.$.ajax({
            url: contextPath + '/rest/dev-status/1.0/issue/targets?cta=' + encodeURIComponent(cta)
                + '&issueId=' + encodeURIComponent(issueId)
        }).done(function(result) {
            deferred.resolve(result);
        }).fail(function(xhr, status) {
            deferred.reject(JIRA.SmartAjax.buildDialogErrorContent(xhr).html());
        });
        return deferred.promise();
    },

    _getIssueId: function(link) {
        return (link && link.data('issueid')) || JIRA.Issue.getIssueId();
    },

    _isUniqueResult: function (data) {
        return data.remoteApps.length === 1 && data.remoteApps[0];
    },

    _toggleEntry: function(elements, index, shouldFocus) {
        var entry = elements.eq(index);
        shouldFocus && entry.focus();
        entry.addClass("selected");
        this.currentSelected = entry;
    },

    _removeSelected: function() {
        if (this.currentSelected) {
            this.currentSelected.removeClass("selected");
            this.currentSelected = null;
        }
    },

    _onTargetKeyboardSelect: function(e) {
        if (e.type === "keydown") {
            var direction = 0;
            if (e.keyCode === this.ARROW_KEY_UP_CODE) {
                direction = -1;
            } else if (e.keyCode === this.ARROW_KEY_DOWN_CODE) {
                direction = 1;
            }

            if (direction !== 0) {
                e.preventDefault();

                var targets = this.$el.find(".target");
                var focusedEntry = targets.index(this.$el.find(".selected"));

                if (focusedEntry !== -1) {
                    targets.eq((focusedEntry + direction) % targets.size()).focus();
                }
            }
        }
    },

    _onTargetFocus: function(e) {
        this._removeSelected();
        this._toggleEntry(AJS.$(e.target), 0, false);
    }
}));