AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-review-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-and-dialog-resources");module("JIRA.DevStatus.DetailDialogReviewView",{setup:function(){this.sandbox=sinon.sandbox.create();this.issueKey="DEV-1";this.issueId=10000;this.server=sinon.fakeServer.create();this.templateSpy=undefined;JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Reviews",this.sandbox);JIRA.DevStatus.ReviewsAnalytics.fireDetailReviewClicked=sinon.spy()},teardown:function(){this.sandbox.restore();this.server.restore();JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();AJS.$("body").css("overflow","initial")},getDetailDialog:function(){var a=AJS.$(".jira-dialog");return{heading:a.find(".devstatus-dialog-heading"),content:a.find(".devstatus-dialog-content"),getReviewContainer:function(){return this.content.find(".detail-reviews-container")},getRows:function(){return this.getReviewContainer().find("tbody tr")},getColumns:function(c){var b=AJS.$(c);return{review:b.find(".review"),title:b.find(".title"),state:b.find(".state"),author:b.find(".author"),reviewers:b.find(".reviewer-container .vcs-user"),extraReviewersLozenge:b.find(".reviewer-container .extrareviewers-tooltip"),reviewerAvatarCount:b.find(".reviewer img").length,truncatedReviewerCount:parseInt(b.find(".reviewer").text()),commentCount:parseInt(b.find(".comment .count").text()),timestamp:b.find(".timestamp"),overDue:b.find(".timestamp .overdue").length>0}},getNoPermissionToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all")},getExtraReviewerInlineDialog:function(b){return{rowsElement:b.find("tr"),rowsValue:function(){var c=[];_.each(this.rowsElement,function(e){var d=AJS.$(e);c.push({name:d.find(".reviewer-name").text(),hasAvatar:d.find(".reviewer-avatar img").length>0})});return c}}}}},createView:function(b){var a=new JIRA.DevStatus.DetailDialogReviewView({count:b,issueKey:this.issueKey,issueId:this.issueId,tabs:{fecru:{name:"FishEye / Crucible",count:b}},dataType:"review",reviewersThreshold:2});this.templateSpy=sinon.spy(a,"template");return a},assertNoNoPermissionMessage:function(){ok(this.getDetailDialog().content.find(".no-permission-to-view-all").length===0,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(this.getDetailDialog().content.find(".aui-message.warning:has(.connection-error)").length===0,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage();this.assertNoConnectionErrorWarning()},assertColumnContent:function(h,k,d,j,c,f,i,b,a,g){var e=h.getColumns(h.getRows()[k]);equal(e.review.text(),d,"Review id rendered for "+d);ok(e.title.text().match(j),"Review title rendered for "+d);equal(e.state.text(),c,"Review status rendered for "+d);equal(e.author.find(".extra-content-in-title").attr("original-title"),f,"Author rendered for "+d);ok(e.author.find("img").length>0,"Avatar rendered for "+d);equal(e.reviewerAvatarCount,i,"Review avatars rendered for  "+d);deepEqual(e.truncatedReviewerCount,b,"Extra reviewer badge rendered "+d);deepEqual(e.commentCount,a,"Comment count rendered for "+d);ok(e.timestamp.text().match(g),"Timestamp rendered for "+d);return e}});test("Test lock screen renders if no data would be displayed",function(){var f="fecru";var e={detail:[{reviews:[]}]};var b=this.createView();var c=AJS.$("#qunit-fixture");c.html('<div id="tab-content-'+f+'"><div class="detail-content-container"></div></div>');b.$el=c;b.renderSuccess=this.sandbox.spy();b._handleFetchSucceeded(f,e);ok(b.renderSuccess.neverCalledWith(f,e.detail));var d=b.getContentContainer(f);var a=d.find(".no-permission-to-view-all");ok(a.find(".lock-image").length>0,"has lock image");equal(a.text(),"You don't have access to view all related reviews. Please contact your administrator.")});test("Test content table is not rendered when JSON response empty",function(){var b=this.createView(1);var d=AJS.$('<div class="jira-dialog"></div>').appendTo(AJS.$("#qunit-fixture"));var a=AJS.$('<div class="devstatus-dialog-content"></div>').appendTo(d);b.getContentContainer=this.sandbox.stub().returns(a);b.renderSuccess("fecru",[]);var c=this.getDetailDialog();equal(c.getReviewContainer().length,0,"Dialog container doesn't exists");equal(c.getRows().length,0,"Table/rows are rendered into the dialog");equal(c.getNoPermissionToViewAllMessage().length,1,"Contains no permission to view all message")});test("Test responses from multiple connected products are combined",function(){var a=this.createView(),c=[{id:"CR-1",lastModified:"2013-11-20T11:49:10.512+0100",state:"Review"},{id:"CR-2",lastModified:"2013-11-20T23:59:10.512+0100",state:"Review"}],b=[{id:"CR-3",lastModified:"2013-10-20T11:49:10.512+0100",state:"Review"},{id:"CR-4",lastModified:"2013-12-20T11:49:10.512+0100",state:"Review"}];a.renderSuccess("fecru",[{reviews:c},{reviews:b}]);deepEqual(this.templateSpy.getCall(0).args[0].reviews,[b[1],c[1],c[0],b[0]],"Reviews combined before template call")});test("Test sorting reviews by lastModified",function(){var a=this.createView(),b=[{id:"CR-1",lastModified:"2013-11-20T11:49:10.512+0100",state:"Review"},{id:"CR-2",lastModified:"2013-11-20T23:59:10.512+0100",state:"Review"},{id:"CR-3",lastModified:"2013-10-20T11:49:10.512+0100",state:"Review"},{id:"CR-4",lastModified:"2013-12-20T11:49:10.512+0100",state:"Review"},{id:"CR-5",lastModified:"2013-11-20T11:49:10.512+0100",dueDate:"2014-12-20T11:49:10.512+0100",state:"Review"},{id:"CR-6",lastModified:"2013-11-20T11:49:10.512+0100",dueDate:"2012-12-20T11:49:10.512+0100",state:"Review"}];a.renderSuccess("fecru",[{reviews:b}]);deepEqual(this.templateSpy.getCall(0).args[0].reviews,[b[5],b[4],b[3],b[1],b[0],b[2]],"Reviews sorted before template call")});test("Test complete and rejected reviews don't have due dates",function(){var a=this.createView(),d={id:"CR-1",lastModified:"2013-11-20T11:49:10.512+0100",dueDate:"4999-11-20T11:49:10.512+0100",reviewers:[]},c=_.extend({state:"Review"},d),b=_.extend({state:"Closed"},d),e=_.extend({state:"Rejected"},d);a.renderSuccess("fecru",[{reviews:[c]}]);a.renderSuccess("fecru",[{reviews:[b]}]);a.renderSuccess("fecru",[{reviews:[e]}]);deepEqual(this.templateSpy.getCall(0).args[0].reviews,[c],"Review in progress due date not stripped");deepEqual(this.templateSpy.getCall(1).args[0].reviews,[_.omit(b,"dueDate")],"Review closed due date stripped");deepEqual(this.templateSpy.getCall(2).args[0].reviews,[_.omit(e,"dueDate")],"Review rejected due date stripped")});test("Test sorting reviewers by completion status",function(){var a=this.createView(),d=[{name:"d",complete:true},{name:"c",complete:false},{name:"b",complete:true},{name:"a",complete:false}],c=[{id:"CR-1",state:"Review",reviewers:d}];var b=_(c).map(a._updateReviewers)[0].reviewers;deepEqual(b,[d[2],d[0],d[3],d[1]],"Reviewers sorted before template call")});test("Test author is excluded from reviewers list",function(){var a=this.createView(),c=[{name:"amy"},{name:"bernice"}],b=[{id:"CR-1",state:"Review",reviewers:c,author:{name:"amy",avatar:"http://foo/bar",emailAddress:"amy@example.com"}}];var d=_(b).map(a._updateReviewers)[0].reviewers;ok(_.contains(d,{name:"amy"})===false,"Author should not be in the reviewers list")});test("Test transforming reviewers",function(){var a=this.createView(),d={name:"c"},e=[{name:"b",complete:false},{name:"a",complete:true}],c=[{id:"CR-1",state:"Review",reviewers:e,moderator:d}];var b=_(c).map(a._updateReviewers)[0].reviewers;deepEqual(b,[d,e[1],e[0]],"Moderator inserted into reviewers")});test("Test transforming reviewers doesn't add moderator if he's the author",function(){var a=this.createView(),d={name:"a",avatar:"http://foo/bar",emailAddress:"moder@tor.com"},e=[{name:"b",complete:false}],c=[{id:"CR-1",state:"Review",reviewers:e,moderator:d,author:d}];var b=_(c).map(a._updateReviewers)[0].reviewers;deepEqual(b,[e[0]],"Moderator not inserted into reviewers if he's a reviewer as well")});test("Test filtering reviews",function(){var a=this.createView(),b=[{id:"CR-1",state:"Draft"},{id:"CR-2",state:"Review"},{id:"CR-3",state:"Approval"},{id:"CR-4",state:"Closed"},{id:"CR-5",state:"Dead"},{id:"CR-6",state:"Unknown"},{id:"CR-6",state:"Summarize"},{id:"CR-7",state:"Rejected"}];a.renderSuccess("fecru",[{reviews:b}]);deepEqual(this.templateSpy.getCall(0).args[0].reviews,[b[1],b[2],b[3],b[6],b[7]],"Reviews filtered before template call")});test("Test event sent when review id clicked",function(){var a=this.createView(0);a.show();a.renderSuccess("fecru",[{reviews:[{id:"CR-2",state:"Review",commentCount:666}]}]);AJS.$(".review-link").click();ok(JIRA.DevStatus.ReviewsAnalytics.fireDetailReviewClicked.calledOnce,"analytics event fired when clicking review id");AJS.$(".comment-link").click();ok(JIRA.DevStatus.ReviewsAnalytics.fireDetailReviewClicked.calledTwice,"analytics event fired when clicking comments link")});test("Test review detail renders dialog with success request",function(){expect(58);JIRA.DevStatus.Date.format="YYYY-MM-DD";var a=this.createView(5);a.show();var d=this.getDetailDialog();var g=d.content.find(".status-loading");var b=d.content.find(".tabs-pane.active-pane");ok(g.is(":visible"),"A spinner is visible  when there is an onflight ajax request");ok(g.children().length>0);ok(b.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request");AJS.TestContractManager.respondToRequest("detail3LO-fecru",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailReviews-multiple",this.server.requests[1]);this.assertNoErrorMessagesInCanvas();ok(!g.is(":visible"),"A spinner is no longer visible when the onflight ajax request has completed");ok(!b.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed");equal(d.getRows().length,5,"Number of pull request rows rendered into the table is correct");var f=this.assertColumnContent(d,0,"PERM-7","patch #2815684","Review","System Administrator",3,NaN,1,/^Due/);ok(f.reviewers.eq(0).find(".approved").length>0,"Review completion mark rendered correctly");ok(f.reviewers.eq(0).find(".fade").length>0,"Review completion fade rendered correctly");ok(f.overDue,"PERM-7 overdue");this.assertColumnContent(d,1,"CR-244","DEF-1 Row row row your boat","Review","Geoff Crain",2,7,2,/^Due/);this.assertColumnContent(d,2,"CR-256","DEF-1: 1","Approval","Matt Quail",2,NaN,NaN,/^Due/);var c=this.assertColumnContent(d,3,"DEF-10","DEF-1: 1","Closed","Matt Quail",2,2,NaN,/^(?!Due).*$/);ok(!c.overDue,"DEF-10 not overdue");var e=this.assertColumnContent(d,4,"DEF-4",".*","Closed","Geoff Crain",0,NaN,101,/^(?!Due)/);ok(!e.overDue,"DEF-4 not overdue")});test("Test reviewer tooltip in detail dialog",function(){JIRA.DevStatus.Date.format="YYYY-MM-DD";var a=this.createView(5);a.show();var b=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detail3LO-fecru",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailReviews-multiple",this.server.requests[1]);var c=1;ok(!_.isObject(a.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is NOT created when the pull request link is NOT hovered");b.getColumns(b.getRows()[c]).extraReviewersLozenge.mouseenter().mousemove();ok(_.isObject(a.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is created when the pull request link is hovered");var d=b.getExtraReviewerInlineDialog(a.reviewerInlineDialogView.activeExtraReviewersToolTip.$content);equal(d.rowsElement.length,7,"number of reviewers in tooltip is correct");deepEqual(_.pluck(d.rowsValue(),"name"),["Brendan Humphreys","Conor MacNeill","George Filippoff","Matt Quail","Peter McNeil","Wojciech Seliga","joe lowercase"],"tooltip content is correct");b.getColumns(b.getRows()[c]).extraReviewersLozenge.mouseleave();ok(!a.reviewerInlineDialogView.activeExtraReviewersToolTip.visible,"activeExtraReviewersToolTip is hidden when mouse is removed")});test("Test extra reviewers are spliced after sorting",function(){var a=this.createView(),b=[{reviews:[{id:"CR-1",state:"REVIEW",reviewers:[{name:"a",complete:false},{name:"b",complete:false},{name:"c",complete:true},{name:"d",complete:true},],moderator:{name:"m"}}]}];var e=a._prepareReviews(b);var d=JSON.parse(e[0].extraReviewers);var c=e[0].reviewers;deepEqual(_.pluck(c,"name"),["Moderator: m","c","d","a","b"],"reviewers should be sorted: moderator first, then completed then notcompleted");deepEqual(_.pluck(d,"name"),["d","a","b"],"extraReviewers should be the tail of the all-reviewer list")});