AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-pullrequest-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");module("JIRA.DevStatus.DetailDialogPullRequestView",{setup:function(){this.sandbox=sinon.sandbox.create();this.issueKey="DEV-1";this.issueId=10000;this.server=sinon.fakeServer.create();JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("PullRequests",this.sandbox)},teardown:function(){this.sandbox.restore();this.server.restore();JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();AJS.$("body").css("overflow","initial")},getDetailDialog:function(){var a=AJS.$(".jira-dialog");return{heading:a.find(".devstatus-dialog-heading"),content:a.find(".devstatus-dialog-content"),getPullRequestContainer:function(){return this.content.find(".detail-pullrequests-container")},getRows:function(){return this.getPullRequestContainer().find(".pullrequest-row")},getColumns:function(c){var b=AJS.$(c);return{author:b.find(".author"),state:b.find(".state"),id:b.find(".pullrequest-id"),title:b.find(".title"),commentCount:b.find(".comment"),reviewer:b.find(".reviewer"),timestamp:b.find(".last-updated")}},getLinks:function(c){var b=this.getColumns(c);return{pullRequest:b.title.find(".pullrequest-link")}},getNoPermissionToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all")},getExtraReviewerInlineDialog:function(b){return{rowsElement:b.find("tr"),rowsValue:function(){var c=[];_.each(this.rowsElement,function(e){var d=AJS.$(e);c.push({name:d.find(".reviewer-name").text(),hasAvatar:d.find(".reviewer-avatar img").length>0})});return c}}}}},createView:function(a){return new JIRA.DevStatus.DetailDialogPullRequestView({count:10,issueKey:this.issueKey,issueId:this.issueId,tabs:{bitbucket:{name:"Bitbucket",count:a||9}},dataType:"pullrequest",reviewersThreshold:2})},assertNoNoPermissionMessage:function(){ok(this.getDetailDialog().content.find(".no-permission-to-view-all").length===0,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(this.getDetailDialog().content.find(".aui-message.warning:has(.connection-error)").length===0,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage();this.assertNoConnectionErrorWarning()}});test("Test content table is not rendered when JSON response empty",function(){var b=this.createView();var d=AJS.$('<div class="jira-dialog"></div>').appendTo(AJS.$("#qunit-fixture"));var a=AJS.$('<div class="devstatus-dialog-content"></div>').appendTo(d);b.getContentContainer=this.sandbox.stub().returns(a);b.renderSuccess("bitbucket",[]);var c=this.getDetailDialog();equal(c.getPullRequestContainer().length,0,"Dialog container doesn't exists");equal(c.getRows().length,0,"Table/rows are not rendered into the dialog");equal(c.getNoPermissionToViewAllMessage().length,1,"Contains no permission to view all message")});test("Test lock screen renders if no data would be displayed",function(){var f="fecru";var e={detail:[{pullRequests:[]}]};var b=this.createView();var c=AJS.$("#qunit-fixture");c.html('<div id="tab-content-'+f+'"><div class="detail-content-container"></div></div>');b.$el=c;b.renderSuccess=this.sandbox.spy();b._handleFetchSucceeded(f,e);ok(b.renderSuccess.neverCalledWith(f,e.detail));var d=b.getContentContainer(f);var a=d.find(".no-permission-to-view-all");ok(a.find(".lock-image").length>0,"has lock image");equal(a.text(),"You don't have access to view all related pull requests. Please contact your administrator.")});test("Test author properly excluded from reviewers",function(){var a=this.createView();var b=[{reviewers:[{name:"amy",name:"bernice"}],author:{name:"amy"}}];var c=a._removeAuthorFromReviewers(b);deepEqual(c,[{reviewers:[{name:"bernice"}],author:{name:"amy"}}])});test("Test empty reviewer PR does not error",function(){var a=this.createView();var b=[{reviewers:[],author:{name:"amy"}}];var c=a._removeAuthorFromReviewers(b);deepEqual(c,[{reviewers:[],author:{name:"amy"}}])});test("Test reviewerless PR does not error",function(){var a=this.createView();var b=[{author:{name:"amy"}}];var c=a._removeAuthorFromReviewers(b);deepEqual(c,[{author:{name:"amy"}}])});test("Test authorless PR is unchanged",function(){var a=this.createView();var b=[{reviewers:[{name:"amy",name:"bernice"}]}];var c=a._removeAuthorFromReviewers(b);deepEqual(c,[{reviewers:[{name:"amy",name:"bernice"}]}])});test("Test responses from multiple connected products are combined and sorted",function(){var a=this.createView();a.template=this.sandbox.spy();a.getContentContainer=this.sandbox.stub().returns(AJS.$("<div></div>"));a.renderSuccess("product",[{pullRequests:[{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"}]},{pullRequests:[{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"}]}]);deepEqual(a.template.getCall(0).args[0].pullRequests,[{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"}].reverse())});test("Test list of pull requests are ordered by pull request id and name",function(){var a=this.createView();deepEqual(a._getSortedPullRequestsByDate([{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"},{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"}]),[{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"}].reverse())});test("Test sorting reviewers in pull requests",function(){var a=this.createView();var b=[{id:"#991",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A",approved:false},{name:"B",approved:true},{name:"C",approved:false}]},{id:"#992",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A"},{name:"B",approved:true},{name:"C",approved:false}]},{id:"#993",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"C",approved:false},{name:"B",approved:false},{name:"A",approved:false}]},{id:"#995",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"C",approved:true},{name:"B",approved:true},{name:"A",approved:true}]},{id:"#994",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{approved:false},{approved:true},{name:"C",approved:false}]}];a._sortReviewers(b);deepEqual(b,[{id:"#991",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"B",approved:true},{name:"A",approved:false},{name:"C",approved:false}]},{id:"#992",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"B",approved:true},{name:"A"},{name:"C",approved:false}]},{id:"#993",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A",approved:false},{name:"B",approved:false},{name:"C",approved:false}]},{id:"#995",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A",approved:true},{name:"B",approved:true},{name:"C",approved:true}]},{id:"#994",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"C",approved:false}]}])});test("Test detail pullrequest dialog with success request",function(){expect(3+2+3+(13*6));JIRA.DevStatus.Date.format="YYYY-MM-DD";var a=this.createView(5);a.show();var d=this.getDetailDialog();var f=d.content.find(".status-loading");var b=d.content.find(".tabs-pane.active-pane");ok(f.is(":visible"),"A spinner is visible  when there is an onflight ajax request");ok(f.children().length>0);ok(b.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request");AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]);this.assertNoErrorMessagesInCanvas();ok(!f.is(":visible"),"A spinner is no longer visible when the onflight ajax request has completed");ok(!b.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed");equal(d.getRows().length,6,"Number of pull request rows rendered into the table is correct");var c=[2,5];var e={"1":3,"0":1};_.each(d.getRows(),function(i,j){var g=d.getColumns(i);ok(g.author.children().length!==0,"Author column is not empty");ok(g.author.find("img").length!==0,"Author column has avatar");ok(!_.isEmpty(g.state.text()),"State column is not empty");ok(!_.isEmpty(g.title.text()),"Title column is not empty");ok(g.id.find("a")!=null,"ID content is a link");ok(g.title.find("a")!=null,"Title content is a link");ok(g.title.find("a").attr("href").indexOf("https://bitbucket.org/fusiontestaccount/ddd-one/pull-request/")!==-1,"Title content has a link");if(_.contains(c,j)){equal(g.reviewer.children().length,0,"Reviewer column is empty");equal(g.reviewer.find("img").length,0,"Reviewer column does not have avatar")}else{ok(g.reviewer.children().length!==0,"Reviewer column is NOT empty");ok(g.reviewer.find("img").length!==0,"Reviewer column has avatar")}var h=e[""+j];if(h){equal(g.commentCount.text(),"Comments"+h,"Comment count is correct")}else{equal(g.commentCount.children().length,0,"Reviewer column is empty")}ok(_.size(g.source)===0,"No Source column");ok(_.size(g.destination)===0,"No Destination column");ok(!_.isEmpty(g.timestamp.text()),"Timestamp column is not empty")})});test("Test reviewer tooltip in detail dialog",function(){JIRA.DevStatus.Date.format="YYYY-MM-DD";var a=this.createView(5);a.options.reviewersThreshold=-1;a.show();var b=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]);equal(b.getRows().length,6,"Number of pull request rows rendered into the table is correct");var d=3;ok(!_.isObject(a.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is NOT created when the pull request link is NOT hovered");b.getColumns(b.getRows()[d]).reviewer.find(".extrareviewers-tooltip").mouseenter().mousemove();ok(_.isObject(a.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is created when the pull request link is hovered");var c=b.getExtraReviewerInlineDialog(a.reviewerInlineDialogView.activeExtraReviewersToolTip.$content);equal(c.rowsElement.length,1,"number of reviewers in tooltip is correct");deepEqual(c.rowsValue(),[{name:"Jimmy Kurniawan",hasAvatar:true}],"tooltip content is correct");b.getColumns(b.getRows()[d]).reviewer.find(".extrareviewers-tooltip").mouseleave();ok(!a.reviewerInlineDialogView.activeExtraReviewersToolTip.visible,"activeExtraReviewersToolTip is hidden when mouse is removed")});test("Test clicking pull request link in pull request detail dialog fires the correct analytics",function(){expect(1+(6*2));var a=this.createView(5);a.show();var b=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]);equal(b.getRows().length,6,"Number of pull request rows rendered into the table is correct");_.each(b.getRows(),function(d,e){var c=b.getLinks(d);c.pullRequest.click();ok(JIRA.DevStatus.PullRequestsAnalytics.fireDetailPullRequestClicked.called,"Analytic event is fired correctly when clicking on pull request link on row "+(e+1));ok(JIRA.DevStatus.PullRequestsAnalytics.fireDetailPullRequestClicked.calledWith("bitbucket"),"Analytic event is fired correctly when clicking on pull request link on row "+(e+1));JIRA.DevStatus.PullRequestsAnalytics.fireDetailPullRequestClicked.reset()})});