AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-review-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");module("JIRA.DevStatus.DetailDialogCommitView",{setup:function(){this.sandbox=sinon.sandbox.create();this.issueKey="DEV-1";this.issueId=123;this.server=sinon.fakeServer.create();this.repoClickedStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailRepoClicked");this.commitClickedStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailCommitClicked");this.branchesShownStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailBranchesShown");this.reviewsShownStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailReviewsShown");this.reviewClickedStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailReviewClicked");this.fileExpandedStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailFileExpandedClicked");this.filesExpandedStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailFilesExpandedClicked");this.fileClickedStub=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailFileClicked");this.createReviewClicked=this.sandbox.stub(JIRA.DevStatus.CommitsAnalytics,"fireDetailCreateReviewClicked")},teardown:function(){this.sandbox.restore();this.server.restore();JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();AJS.$("body").css("overflow","initial");AJS.Meta.set("fusion-open-detail-dialog",undefined)},getCommitDetailDialog:function(){var a=AJS.$(".jira-dialog");return{heading:a.find(".devstatus-dialog-heading"),content:a.find(".devstatus-dialog-content")}},getCommitRows:function(a){return a.find("tbody tr.commitrow")},createView:function(b,a){return new JIRA.DevStatus.DetailDialogCommitView({count:10,el:a,issueId:this.issueId,issueKey:this.issueKey,tabs:{bitbucket:{name:"Bitbucket",count:b||9}}})},assertNoNoPermissionMessage:function(){ok(this.getCommitDetailDialog().content.find(".no-permission-to-view-all").length===0,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(this.getCommitDetailDialog().content.find(".aui-message.warning:has(.connection-error)").length===0,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage();this.assertNoConnectionErrorWarning()},renderViewFromContracts:function(b,d){var a=this.createView(d||5);a.show();for(var c=0;c<b.length;c++){AJS.TestContractManager.respondToRequest(b[c],this.server.requests[c])}},renderFromData:function(a,d){var d=d||"fecru";var c=AJS.$("#qunit-fixture");c.html('<div id="tab-content-'+d+'"><div class="detail-content-container"></div></div>');var b=this.createView(1,c);b.renderSuccess(d,a);return b}});test("Test bitbucket detail commits repositories and commits are ordered",function(){var a=this.createView();deepEqual(a.sortRepositoriesAndCommits([{name:"z",commits:[]},{name:"a",commits:[]},{name:"M",commits:[{authorTimestamp:"2013-10-22T15:33:50.000+1100"},{authorTimestamp:"2011-10-22T15:33:50.000+1100"},{authorTimestamp:"2012-10-22T15:33:50.000+1100"}]}]),[{name:"a",commits:[]},{name:"M",commits:[{authorTimestamp:"2013-10-22T15:33:50.000+1100"},{authorTimestamp:"2012-10-22T15:33:50.000+1100"},{authorTimestamp:"2011-10-22T15:33:50.000+1100"}]},{name:"z",commits:[]}])});test("Test commit detail dialog renders reviews and branches",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewsAndBranches"]);var d=this.getCommitRows(AJS.$(".devstatus-detail-table"));var f=d.eq(0);var c=d.eq(1);var a=d.eq(2);var e=f.find(".branches-link");var b=c.find(".branches-link");var g=a.find(".reviews-link");equal(e.find(".aui-iconfont-devtools-branch-small").length,1,"Branch icon rendered");equal(e.find(".branch-count").length,0,"Branch count not rendered");equal(f.find(".reviews-link").length,0,"Review lozenge not rendered");equal(b.find(".aui-iconfont-devtools-branch-small").length,1,"Branch icon rendered");equal(b.find(".branch-count").text(),"21","Branch count rendered");equal(g.length,1,"Review link rendered");equal(g.text(),"Review","Review link status rendered")});test("Test commit detail dialog renders instance names",function(){var b=this.renderFromData([{repositories:[{name:"instance1-repo1"},{name:"instance1-repo2"}],_instance:{name:"instance1"}},{repositories:[{name:"instance2-repo1"}],_instance:{name:"instance2"}}]);var a=b.$el.find(".repository-instance");equal(a.length,3,"Rendered repository instance names");equal(a.eq(0).text(),"(instance1)","Rendered repository instance name");equal(a.eq(1).text(),"(instance1)","Rendered repository instance name");equal(a.eq(2).text(),"(instance2)","Rendered repository instance name")});test("Test repository instance names aren't rendered when there's only one",function(){var a=this.createView();var b=a.concatResults([{repositories:[{name:"instance1-repo1"},{name:"instance1-repo2"}],_instance:{name:"instance1",singleInstance:true}}]);ok(!b[0].showInstance,"Set to not show instance for repos from a single instance");ok(!b[1].showInstance,"Set to not show instance for repos from a single instance")});test("Test commit detail dialog renders default avatar if none provided",function(){var b="http://localhost/foobar",a=this.renderFromData([{repositories:[{name:"instance1-repo1",avatar:b},{name:"instance1-repo2"}]}]);var c=a.$el.find(".project-avatar");equal(c.length,2,"Rendered repository avatars");equal(c.eq(0).find("img").attr("src"),b,"Rendered provided repository avatar image");equal(c.eq(1).find(".aui-iconfont-devtools-repository").length,1,"Rendered default repository avatar if no image provided")});test("Test commit detail dialog uses repository avatar description for project tooltip",function(){var a=this.renderFromData([{repositories:[{name:"instance1-repo1",avatarDescription:"project"},{name:"instance1-repo2"}]}]);var b=a.$el.find(".project-avatar");equal(b.eq(0).attr("title"),"project");equal(b.eq(1).attr("title"),undefined)});test("Test commit detail dialog renders files",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-files"]);var b=this.getCommitRows(AJS.$(".devstatus-detail-table"));function d(g,h,j){var e=b.eq(g);equal(e.find(".filecount").text(),h);var f=e.next();j(f.find(".file"))}function c(e){return function(f){equal(f.length,e.length);f.each(function(h){var g=AJS.$(this);equal(g.find(".changetype").text().toUpperCase(),e[h].type);equal(g.find(".filename").text(),e[h].name)})}}function a(e){return function(f){equal(f.length,e.length);f.each(function(h){var g=AJS.$(this);if(e[h].type){equal(g.find(".lines").text().toUpperCase(),e[h].type)}else{equal(g.find(".lines .added").text(),"+"+e[h].added);equal(g.find(".lines .removed").text(),"-"+e[h].removed)}equal(g.find(".filename").text(),e[h].name)})}}d(0,"10 files",c([{type:"ADDED",name:"a"},{type:"COPIED",name:"b"},{type:"MOVED",name:"c"},{type:"DELETED",name:"d"},{type:"MODIFIED",name:"e"}]));d(1,"",c([]));d(2,"3 files",a([{type:"ADDED",name:"a"},{type:"DELETED",name:"b"},{name:"c",added:3,removed:8}]));d(3,"1 file",c([{type:"MODIFIED",name:"plugins/branch-utils/src/test/java/com/atlassian/stash/internal/branch/list/aheadbehind/ShowBranchAheadBehindCountingOutputHandlerTest.java"}]))});test("Test commit detail dialog file count",function(){equal(AJS.$(JIRA.Templates.DevStatus.DetailDialog.filesColumn({count:1})).text(),"1 file");equal(AJS.$(JIRA.Templates.DevStatus.DetailDialog.filesColumn({count:99})).text(),"99 files");equal(AJS.$(JIRA.Templates.DevStatus.DetailDialog.filesColumn({count:100})).text(),"100+ files")});test("Test commit detail dialog toggle files",function(){var b=this;this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-files"]);var c=this.getCommitRows(AJS.$(".devstatus-detail-table")).filter(function(){return AJS.$(this).find(".filecount").text()!==""});var d=c.closest(".detail-commits-container").find(".file-expand a");function f(g){equal(d.text(),g?"Hide files":"Show all files","Expand show/hide state")}function e(g,h){equal(c.eq(g).next().hasClass("hidden"),h,"File row visibility: "+g)}function a(g){c.eq(g).find(".filecount a").click()}ok(true,"Everything should be closed");f(false);c.each(function(g){e(g,true)});ok(true,"Toggle one file at a time");c.each(function(g){a(g);ok(b.fileExpandedStub.calledOnce,"Analytic event fired when showing files for a single commit");b.fileExpandedStub.reset();e(g,false);f(true)});ok(true,"Hide one");a(0);e(0,true);f(true);ok(!b.fileExpandedStub.called,"Analytic event not fired when hiding files for a single commit");ok(true,"Hide them all");d.click();ok(!this.filesExpandedStub.called,"Analytic event not fired when hiding all files");f(false);c.each(function(g){e(g,true)});ok(true,"Expand them all");d.click();ok(this.filesExpandedStub.called,"Analytic event fired when showing all files");f(true);c.each(function(g){e(g,false)});ok(true,"Hide one file");a(0);e(0,true);f(true);AJS.$(".filename:visible a").eq(0).click();ok(this.fileClickedStub.called)});test("Test lock screen renders if no data would be displayed",function(){var f="fecru";var e={detail:[{repositories:[]}]};var b=this.createView();var c=AJS.$("#qunit-fixture");c.html('<div id="tab-content-'+f+'"><div class="detail-content-container"></div></div>');b.$el=c;b.renderSuccess=this.sandbox.spy();b._handleFetchSucceeded(f,e);ok(b.renderSuccess.neverCalledWith(f,e.detail));var d=b.getContentContainer(f);var a=d.find(".no-permission-to-view-all");ok(a.find(".lock-image").length>0,"has lock image");equal(a.text(),"You don't have access to view all related commits. Please contact your administrator.")});test("Filenames are correctly clipped",function(){var c="long-name/averylongnameindeed/indeeditissuchaverylongnameimrathershocked/whyisitthatthefilenameisstillgoing/thisisincrediblehave/you/ever/seen/AnythingLikeIt.java";var a=this.renderFromData([{repositories:[{name:"instance1-repo1",avatarDescription:"project",commits:[{fileCount:1,author:"mclovin",files:[{changeType:"BLOGGED",url:"http://example.com",path:c}]}]}]}]);var b=this.getCommitRows(a.$el.find(".devstatus-detail-table"));var e=b.eq(0);ok(a.$el.find(".filerow").hasClass("hidden"));a.$el.find(".file .filename").css("white-space","nowrap").css("width","300px");e.find(".filecount a").click();var d=a.$el.find(".file .filename a").eq(0);ok(d.text().length<c.length)});test("Test commit detail dialog renders branch tooltip",JIRA.DevStatus.QunitTestUtils.withFakeTimer(function(d){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewsAndBranches"]);var b=this.getCommitRows(AJS.$(".devstatus-detail-table")).eq(1);var e=b.find(".branches-link");e.trigger("mouseover");d.tick(500);var c=AJS.$(".branch-tooltip");equal(c.length,1,"Branch tooltip rendered");ok(this.branchesShownStub.calledWith("bitbucket"),"Analytic event fired when branches tooltip rendered");var a=c.find(".branch-name-tooltip");equal(a.length,5,"All branches rendered");equal(a.eq(0).text(),"master","Branch name rendered");equal(a.eq(1).text(),"manybranches-test-190fds-df-very-long-branch-name-very-long-long","Branch name rendered");equal(a.eq(2).text(),"manybranches-test-4","Branch name rendered");equal(a.eq(3).text(),"manybranches-test-3","Branch name rendered");equal(a.eq(4).text(),"manybranches-test-2","Branch name rendered");equal(c.find(".branch-tooltip-summary").text(),"and 16 more","Branch summary rendered");c.parent().parent().remove()}));test("Test commit detail dialog renders review popup",JIRA.DevStatus.QunitTestUtils.withFakeTimer(function(d){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewsAndBranches"]);var c=this.getCommitRows(AJS.$(".devstatus-detail-table")).eq(2);var f=c.find(".reviews-link");f.mouseenter().mousemove();d.tick(500);var e=AJS.$("#inline-dialog-commit-reviews-popup");equal(e.length,1,"Review popup rendered");ok(this.reviewsShownStub.calledWith("bitbucket"),"Analytic event fired when review popup rendered");var b=e.find(".inline-review-row");equal(b.length,2,"All reviews rendered");equal(b.eq(0).find(".inline-review-id").text(),"CR-256","Review id rendered");equal(b.eq(0).find(".inline-review-state").text(),"Review","Review state rendered");equal(b.eq(1).find(".inline-review-id").text(),"DEF-10","Review id rendered");equal(b.eq(1).find(".inline-review-state").text(),"Closed","Review state rendered");b.eq(0).find("a").click();ok(this.reviewClickedStub.calledWith("bitbucket"),"Analytic event fired when review clicked");var a=e.find(".inline-review-summary");equal(a.text(),"and 18 more","Review summary rendered");equal(a.find("a").attr("href"),"http://lpater-dev:8060/foo/changelog/gitsample?cs=155a0e9308d7e4b06ad1ec146244980839f61951","Review summary link rendered");a.find("a").click();ok(this.reviewClickedStub.calledTwice,"Analytic event fired when review clicked");e.remove()}));test("Test reviews are sorted by priority",function(){var a=this.createView(),b={id:"cs1",reviews:{totalCount:9,reviews:[{id:"CR-6",state:"CLOSED"},{id:"CR-5",state:"REJECTED"},{id:"CR-1",state:"REVIEW"},{id:"CR-3",state:"APPROVAL"},{id:"CR-4",state:"SUMMARIZE"},{id:"CR-2",state:"REVIEW"}]}};a._orderCommitReviews(b);deepEqual(_.reduce(b.reviews.reviews,function(c,d){c.push(d.id);return c},[]),["CR-1","CR-2","CR-3","CR-4","CR-5","CR-6"])});test("Test reviews in invalid states are filtered",function(){var a=this.createView(),b={id:"cs1",reviews:{totalCount:9,reviews:[{id:"CR-6",state:"DRAFT"},{id:"CR-5",state:"DEAD"},{id:"CR-1",state:"REVIEW"},{id:"CR-3",state:"fooo"},{id:"CR-4"}]}};a._orderCommitReviews(b);equal(b.reviews.reviews.length,1,"Reviews in invalid states were filtered");equal(b.reviews.reviews[0].id,"CR-1","Reviews in valid states were preserved")});test("Test checking if repositories have reviews",function(){var a=this.createView(),b=[{name:"a",commits:[]},{name:"b",commits:[{id:"1"}]},{name:"c",commits:[{id:"1",reviews:null}]},{name:"d",commits:[{id:"1",reviews:undefined}]},{name:"e",commits:[{id:"1",reviews:{}}]},{name:"f",commits:[{id:"1",reviews:{totalCount:0,reviews:[]}}]},{name:"g",commits:[{id:"1",reviews:{totalCount:100,reviews:[{id:"CR-1"}]}}]},{name:"g",commits:[{id:"0"},{id:"1",reviews:{totalCount:100,reviews:[{id:"CR-1"}]}}]}];a.transformRepositories(b);ok(!b[0].showReviews,"don't show reviews if no commits");ok(!b[1].showReviews,"dont't show reviews if no commits with review prop");ok(!b[2].showReviews,"don't show reviews if review prop null");ok(!b[3].showReviews,"don't show reviews if review prop undefined");ok(b[4].showReviews,"show reviews if review object present");ok(b[5].showReviews,"show reviews if review object present");ok(b[6].showReviews,"show reviews if review object present");ok(b[7].showReviews,"show reviews if review object in at least one commit")});test("Test checking if repositories have branches",function(){var a=this.createView(),b=[{name:"a",commits:[]},{name:"b",commits:[{id:"1"}]},{name:"c",commits:[{id:"1",branches:null}]},{name:"d",commits:[{id:"1",branches:undefined}]},{name:"e",commits:[{id:"1",branches:{}}]},{name:"f",commits:[{id:"1",branches:{totalCount:0,branches:[]}}]},{name:"g",commits:[{id:"1",branches:{totalCount:100,branches:[{id:"CR-1"}]}}]},{name:"g",commits:[{id:"0"},{id:"1",branches:{totalCount:100,branches:[{id:"CR-1"}]}}]}];a.transformRepositories(b);ok(!b[0].showBranches,"don't show branches if no commits");ok(!b[1].showBranches,"dont't show branches if no commits with branches prop");ok(!b[2].showBranches,"don't show branches if branches prop null");ok(!b[3].showBranches,"don't show branches if branches prop undefined");ok(b[4].showBranches,"show branches if branches object present");ok(b[5].showBranches,"show branches if branches object present");ok(b[6].showBranches,"show branches if branches object present");ok(b[7].showBranches,"show branches if branches object in at least one commit")});test("Test checking if repositories have files",function(){var a=this.createView(),b=[{name:"a",commits:[{id:"1"}]},{name:"b",commits:[{id:"1",files:[]}]}];a.transformRepositories(b);ok(!b[0].showFiles,"don't show files if commit object has no files");ok(b[1].showFiles,"show files if commit object has files")});test("Test get unique commit count",function(){var a=this.createView();equal(a.getUniqueCommitCount([]),0,"no repo");equal(a.getUniqueCommitCount([{name:"M"}]),0,"one repo no commits");equal(a.getUniqueCommitCount([{name:"M",commits:[]}]),0,"one repo empty commits");equal(a.getUniqueCommitCount([{name:"M",commits:[{id:undefined},{id:null},{id:"3"},{name:"name"}]}]),1,"one repo with null id");equal(a.getUniqueCommitCount([{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),3,"one repo");equal(a.getUniqueCommitCount([{name:"z",commits:[]},{name:"a",commits:[]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),3,"one repo with empty repo");equal(a.getUniqueCommitCount([{name:"z",commits:[]},{name:"a",commits:[{id:"4"}]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),4,"two repos with no overlap");equal(a.getUniqueCommitCount([{name:"z",commits:[]},{name:"a",commits:[{id:"1"},{id:"4"}]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),4,"two repos with overlap");equal(a.getUniqueCommitCount([{name:"z",commits:[{id:"5"},{id:"3"}]},{name:"a",commits:[{id:"1"},{id:"4"}]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),5,"three repos with overlap")});test("Test bitbucket detail commits dialog with success request",function(){expect(28);JIRA.DevStatus.Date.format="YYYY-MM-DD";var c=this.createView(5);c.show();var f=this.getCommitDetailDialog();var h=f.content.find(".status-loading");var d=f.content.find(".tabs-pane.active-pane");var g=["repoAWESOME","repoGOOD","repoone"];var e=[3,1,2];ok(h.is(":visible"),"A spinner is visible  when there is an onflight ajax request");ok(h.children().length>0);ok(d.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request");AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("bitbucketDetailCommit-multipleRepo",this.server.requests[1]);this.assertNoErrorMessagesInCanvas();var b=f.content.find(".detail-commits-container");var a=f.content.find("tr[data-changesetid='jklmnalsotoolong']");ok(!h.is(":visible"),"A spinner is no longer visible when the onflight ajax request has completed");ok(!d.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed");equal(b.length,g.length,"Number of commit tables rendered into the dialog is correct");_.each(b,_.bind(function(k,j){var m=AJS.$(k);var o=m.find(".repository-link");equal(o.text(),g[j],"The repository name exist and is correct: "+j);o.click();ok(this.repoClickedStub.called,"Analytic event is fired correctly when clicking on repo link: "+j);var i=this.getCommitRows(m.find(".commits-table"));equal(i.length,e[j],"List of commits exist and contains the correct number: "+j);var l=i.find(".changesetid");l.eq(0).click();ok(this.commitClickedStub.called,"Analytic event is fired correctly when clicking on commit link: "+j);var n=i.find(".timestamp .livestamp");ok(n.length!=0,"Time stamp is rendered into the table");equal(n.attr("title"),"2013-09-23","Tooltip is correctly appended onto the timestamp element: "+j)},this));ok(a.hasClass("merge"),"Merge commit is correctly displayed");equal(a.find(".aui-lozenge.merge").length,1,"Merge row is correctly appended with a merge lozenge")});test("Test bitbucket detail commits dialog with success request with one repo",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-oneRepo"],2);this.assertNoErrorMessagesInCanvas();var a=this.getCommitDetailDialog().content.find(".detail-commits-container");equal(a.length,1,"One commit table is rendered into the dialog");equal(a.find(".repository-link").text(),"repoone","The repository name exist and is correct")});test("Test bitbucket detail commits dialog with success request and errors",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-multipleRepoWithErrors"],2);equal(this.server.requests.length,3,"A third request was sent");ok(this.server.requests[2].url.indexOf("/provider/auth-status")>0,"The third request was to re-fetch auth status");AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[2]);this.assertNoNoPermissionMessage();var b=this.getCommitDetailDialog();equal(b.content.find(".detail-commits-container").length,3,"There are still commits visible with errors");equal(b.content.find(".authentication-problem h2").length,0,"No authenticate message is shown when there is data");equal(b.content.find(".connection-problem h2").length,0,"No connection message is shown in full canvas when there is data");equal(b.content.find(".aui-message.warning").length,1,"Connection message is prepended to commit table when there is connection problem");var a=b.content.find(".aui-message.warning").text();ok(a.indexOf("JIRA is having difficulty contacting")>=0&&a.indexOf("If this condition persists, please contact your ")>=0,"Correct connection message is prepended to commit table when there is connection problem")});test("Test bitbucket detail commits dialog with only authentication errors",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit3LO-stashUnauthorizedError"]);equal(this.server.requests.length,3,"A third request was sent");ok(this.server.requests[2].url.indexOf("/provider/auth-status")>0,"The third request was to re-fetch auth status");AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[2]);var a=this.getCommitDetailDialog();equal(a.content.find(".detail-commits-container").length,0,"There is no commits table on ajax request without data");equal(a.content.find(".authentication-problem h2").text(),"Authenticate to see related commits","Authentication message is shown when there's no data and with authentication problem")});test("Test bitbucket detail commits dialog with only connection errors",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit3LO-stashOtherError"]);equal(this.server.requests.length,2,"No auth status re-fetch request was sent");var a=this.getCommitDetailDialog();equal(a.content.find(".detail-commits-container").length,0,"There is no commits table on ajax request without data");equal(a.content.find(".connection-problem h2").text(),"Unable to retrieve commit information","Connection message is shown in full canvas when there's no data and with connection problem")});test("Test bitbucket detail commits dialog with success but no permission to view any commits",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-empty"],1);var a=this.getCommitDetailDialog();equal(a.content.find(".detail-commits-container").length,0,"There is no commits table on fail ajax request");equal(a.content.find(".no-permission-to-view-all").text(),"You don't have access to view all related commits. Please contact your administrator.","No permission message is shown in full canvas where there's no data")});test("Test bitbucket detail commits dialog with success but no permission to view some commits",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-multipleRepo"],6);this.assertNoConnectionErrorWarning();var a=this.getCommitDetailDialog();ok(a.content.find(".detail-commits-container").length>0,"There are commits visible");equal(a.content.find(".no-permission-to-view-all").text(),"You don't have access to view all related commits. Please contact your administrator.","No permission message is shown in full canvas where there's no data")});test("Test bitbucket detail commits dialog with fail request",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-failRequest"]);var a=this.getCommitDetailDialog();equal(a.content.find(".detail-commits-container").length,0,"There is no commits table on fail ajax request");equal(a.content.find(".connection-problem h2").text(),"Unable to retrieve commit information","A message is shown when ajax request failed")});test("Test review creation for changeset",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation"]);var a=this.getCommitDetailDialog();var b=a.content.find(".commits-table .create-review-commit a");b.click();equal(b.length,1,"Create review link rendered");equal(b.eq(0).attr("href"),"http://fecru/cru/create?repo=gitsample&csid=3da7cf6a980221195e9d09dd80c30c3a002a0c54","Correct href rendered");ok(this.createReviewClicked.calledWith("bitbucket",false))});test("Test review creation for single instance",function(){JIRA.Issue.getIssueId=this.sandbox.stub().returns(123);this.sandbox.stub(JIRA.DevStatus.Navigate,"navigate");this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation"]);var a=this.getCommitDetailDialog();var b=a.content.find(".create-review-instance a");equal(b.length,1,"Create review link rendered");b.eq(0).click();equal(this.server.requests.length,3,"Request for targets sent");AJS.TestContractManager.respondToRequest("createReviewDialog-targets",this.server.requests[2]);equal(AJS.$("#devstatus-cta-create-review-dialog:visible").length,0,"No dialog shown");ok(JIRA.DevStatus.Navigate.navigate.called,"Navigate called");equal(JIRA.DevStatus.Navigate.navigate.getCall(0).args[0],"http://lpater-dev:8060/foo/cru/create?issueKey=DEF-1&issueSummary=1&issueDescription=This+is+an+issue+descriptopn","Navigated to the right url");ok(this.createReviewClicked.calledWith("bitbucket",true))});test("Test review creation for multiple instances",function(){JIRA.Issue.getIssueId=this.sandbox.stub().returns(123);this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation-twoInstances"]);var a=this.getCommitDetailDialog();var b=a.content.find(".create-review-instance a");equal(b.length,1,"Create review link rendered");b.eq(0).click();equal(this.server.requests.length,3,"Request for targets sent");AJS.TestContractManager.respondToRequest("createReviewDialog-targets",this.server.requests[2]);AJS.$("#devstatus-cta-create-review-dialog .target").eq(0).click();equal(AJS.$("#devstatus-cta-create-review-dialog").length,1,"Choose instance dialog shown");equal(AJS.$("#devstatus-cta-create-review-dialog .target").length,2,"Two instances shown in the picker");equal(AJS.$("#devstatus-cta-create-review-dialog .target .title").eq(0).text(),"lpater-dev","Instance name shown");equal(AJS.$("#devstatus-cta-create-review-dialog .target .title").eq(1).text(),"lpater-dev-2","Instance name shown");ok(!AJS.$("#devstatus-cta-create-review-dialog .target").eq(0).hasClass("selected"),"Primary instance picked by default");ok(AJS.$("#devstatus-cta-create-review-dialog .target").eq(1).hasClass("selected"),"Primary instance picked by default");ok(this.createReviewClicked.calledWith("bitbucket",true))});test("Test review creation works by following link - single instance",function(){AJS.Meta.set("fusion-open-detail-dialog","create-review-bitbucket");JIRA.Issue.getIssueId=this.sandbox.stub().returns(123);this.sandbox.stub(JIRA.DevStatus.Navigate,"navigate");this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation","createReviewDialog-targets"]);var a=this.getCommitDetailDialog();ok(JIRA.DevStatus.Navigate.navigate.called,"Navigate called");equal(JIRA.DevStatus.Navigate.navigate.getCall(0).args[0],"http://lpater-dev:8060/foo/cru/create?issueKey=DEF-1&issueSummary=1&issueDescription=This+is+an+issue+descriptopn","Navigated to the right url")});test("Test review creation works by following link - multiple instances",function(){AJS.Meta.set("fusion-open-detail-dialog","create-review-bitbucket");JIRA.Issue.getIssueId=this.sandbox.stub().returns(123);this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation-twoInstances","createReviewDialog-targets"]);var a=this.getCommitDetailDialog();equal(AJS.$("#devstatus-cta-create-review-dialog:visible").length,1,"Choose instance dialog shown")});test("Test create review instances not shown if no link from remote",function(){var a=this.renderFromData([{repositories:[{name:"foo",commits:[]}],_instance:{name:"theta"}},{repositories:[{name:"foo",commits:[{author:"lpater"}]}],_instance:{name:"zeta"}},{repositories:[{name:"foo",commits:[{createReviewUrl:"http://review",author:"lpater"}]}],_instance:{name:"eta"}},{repositories:[],_instance:{name:"teta"}}]);deepEqual(_.pluck(a.createReviewDialog.instances,"name"),["eta"])});test("Heading text for commits contains no duplicates",function(){var a=this.createView();a.show();var b=this.getCommitDetailDialog();equal(b.heading.text(),this.issueKey+": 10 unique commits")});test("Heading text for commits contains duplicates",function(){var a=this.createView();a.model.set("tabs",{bitbucket:{name:"Bitbucket",count:7},stash:{name:"Stash",count:6}});a.show();var b=this.getCommitDetailDialog();equal(b.heading.text(),this.issueKey+": 10 unique commits (and 3 duplicates)")});