AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-pullrequest-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");module("JIRA.DevStatus.DetailDialogBranchView",{setup:function(){this.sandbox=sinon.sandbox.create();this.issueKey="DEV-1";this.issueId=10000;this.server=sinon.fakeServer.create();JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Branches",this.sandbox)},teardown:function(){this.sandbox.restore();this.server.restore();JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();AJS.$("body").css("overflow","initial")},getDetailDialog:function(){var a=AJS.$(".jira-dialog");return{heading:a.find(".devstatus-dialog-heading"),content:a.find(".devstatus-dialog-content"),getBranchContainer:function(){return this.content.find(".detail-branches-container")},getRows:function(){return this.getBranchContainer().find(".branch-row")},getColumns:function(c){var b=AJS.$(c);return{repository:b.find(".repository"),branch:b.find(".branch"),pullRequest:b.find(".pullrequest"),action:b.find(".action"),changeset:b.find(".changeset"),lastUpdated:b.find(".last-updated time")}},getLinks:function(c){var b=this.getColumns(c);return{repository:b.repository.find(".repository-link"),branch:b.branch.find(".branch-link"),pullRequest:b.pullRequest.find(".pullrequest-link"),createPullRequest:b.action.find(".create-pullrequest-link"),changeset:b.changeset.find(".changeset-link")}},getPullRequestInlineDialog:function(b){return{rowsElement:b.find("tr"),rowsValue:function(){var c=[];_.each(this.rowsElement,function(e){var d=AJS.$(e);c.push({name:d.find(".pullrequest-name").text(),state:d.find(".pullrequest-state").text()})});return c}}},getNoPermissionToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all")}}},createView:function(a){this.view=new JIRA.DevStatus.DetailDialogBranchView({count:10,issueKey:this.issueKey,issueId:this.issueId,tabs:{bitbucket:{name:"Bitbucket",count:a||9}}});return this.view},setAnalyticsDataForView:function(a,b){this.view.analyticIssueData={isAssignee:a,isAssignable:b}},assertNoNoPermissionMessage:function(){ok(this.getDetailDialog().content.find(".no-permission-to-view-all").length===0,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(this.getDetailDialog().content.find(".aui-message.warning:has(.connection-error)").length===0,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage();this.assertNoConnectionErrorWarning()}});test("Test content table is not rendered when JSON response empty",function(){var b=this.createView();var d=AJS.$('<div class="jira-dialog"></div>').appendTo(AJS.$("#qunit-fixture"));var a=AJS.$('<div class="devstatus-dialog-content"></div>').appendTo(d);b.getContentContainer=this.sandbox.stub().returns(a);b.renderSuccess("bitbucket",[]);var c=this.getDetailDialog();equal(c.getBranchContainer().length,0,"Dialog container doesn't exists");equal(c.getRows().length,0,"Table/rows are not rendered into the dialog");equal(c.getNoPermissionToViewAllMessage().length,1,"Contains no permission to view all message")});test("Test lock screen renders if no data would be displayed",function(){var f="fecru";var e={detail:[{branches:[]}]};var b=this.createView();var c=AJS.$("#qunit-fixture");c.html('<div id="tab-content-'+f+'"><div class="detail-content-container"></div></div>');b.$el=c;b.renderSuccess=this.sandbox.spy();b._handleFetchSucceeded(f,e);ok(b.renderSuccess.neverCalledWith(f,e.detail));var d=b.getContentContainer(f);var a=d.find(".no-permission-to-view-all");ok(a.find(".lock-image").length>0,"has lock image");equal(a.text(),"You don't have access to view all related branches. Please contact your administrator.")});test("Test responses from multiple connected products are combined and sorted",function(){var a=this.createView();a.template=this.sandbox.spy();a.getContentContainer=this.sandbox.stub().returns(AJS.$("<div></div>"));a.renderSuccess("product",[{branches:[{name:"D",pullRequests:[],repository:[]},{name:"C",pullRequests:[],repository:[]}]},{branches:[{name:"B",pullRequests:[],repository:[]}]}]);deepEqual(a.template.getCall(0).args[0].branches,[{name:"B",pullRequests:[],repository:[],pullRequestState:{data:"[]",status:undefined,total:0}},{name:"C",pullRequests:[],repository:[],pullRequestState:{data:"[]",status:undefined,total:0}},{name:"D",pullRequests:[],repository:[],pullRequestState:{data:"[]",status:undefined,total:0}}])});test("Test list of branches are ordered by repository name and then branch name",function(){var a=this.createView();deepEqual(a._sortBranchesByName([{name:"D",repository:{name:"B"},pullRequests:[{id:"#4",name:"a"},{id:"#3",name:"b"}]},{name:"C",repository:{name:"B"},pullRequests:[]},{name:"C",repository:{name:"0"},pullRequests:[]},{name:"D",repository:{name:"0"},pullRequests:[]},{name:"B",repository:{name:"0"},pullRequests:[]}]),[{name:"B",repository:{name:"0"},pullRequests:[]},{name:"C",repository:{name:"0"},pullRequests:[]},{name:"D",repository:{name:"0"},pullRequests:[]},{name:"C",repository:{name:"B"},pullRequests:[]},{name:"D",repository:{name:"B"},pullRequests:[{id:"#4",name:"a"},{id:"#3",name:"b"}]}])});test("List of pull requests are summarised for branch",function(){var a=this.createView();deepEqual(a._populatePullRequestStateByBranch([{name:"D",url:"http://somelocation.com"},{name:"C",url:"http://somelocation2.com"},{name:"A",url:"http://somelocation3.com"}],[{status:"MERGED",source:{url:"http://somelocation.com"}},{status:"DECLINED",source:{url:"http://somelocation.com"}},{status:"OPEN",url:"http://url.com",source:{url:"http://somelocation2.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"OPEN",source:{url:"http://somelocation3.com"}},{status:"DECLINED",source:{url:"http://somelocation3.com"}}]),[{name:"D",url:"http://somelocation.com",pullRequestState:{data:JSON.stringify([{status:"MERGED",source:{url:"http://somelocation.com"}},{status:"DECLINED",source:{url:"http://somelocation.com"}}]),status:"MERGED",total:2}},{name:"C",url:"http://somelocation2.com",pullRequestState:{data:JSON.stringify([{status:"OPEN",url:"http://url.com",source:{url:"http://somelocation2.com"}}]),status:"OPEN",total:1}},{name:"A",url:"http://somelocation3.com",pullRequestState:{data:JSON.stringify([{status:"OPEN",source:{url:"http://somelocation3.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"DECLINED",source:{url:"http://somelocation3.com"}}]),status:"OPEN",total:4}}])});test("Sort pull requests by status",function(){var a=this.createView();deepEqual(a._sortPullRequestsByStatus([{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.083+1100"},{status:"OPEN",lastUpdated:"2013-11-15T16:52:40.081+1100"}]),[{status:"OPEN",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.083+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.081+1100"}])});test("Branches with null repository is not rendered",function(){this.issueKey="DEV-2";this.issueId=10001;var a=this.createView(4);a.show();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-nullRepo",this.server.requests[1]);var b=this.getDetailDialog();equal(b.getRows().length,0,"No branch is rendered onto the dialog")});test("Test detail branch dialog with success request",function(){expect(3+2+3+(10*5)+5);JIRA.DevStatus.Date.format="YYYY-MM-DD";var a=this.createView(4);a.show();var d=this.getDetailDialog();var f=d.content.find(".status-loading");var b=d.content.find(".tabs-pane.active-pane");ok(f.is(":visible"),"A spinner is visible  when there is an onflight ajax request");ok(f.children().length>0);ok(b.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request");AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]);this.assertNoErrorMessagesInCanvas();ok(!f.is(":visible"),"A spinner is no longer visible when the onflight ajax request has completed");ok(!b.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed");equal(d.getRows().length,5,"Number of branch rows rendered into the table is correct");var c=[0];_.each(d.getRows(),function(i,j){var g=d.getColumns(i);ok(!_.isEmpty(g.repository.text()),"Repository column is not empty");ok(g.repository.find("a")!=null,"Repository content is a link");equal(g.repository.find("a").attr("href"),"https://bitbucket.org/fusiontestaccount/ddd-one","Repository content has a link");var h=g.branch.text();ok(!_.isEmpty(h),"Branch column is not empty");ok(g.branch.find("a")!=null,"Branch content is a link");equal(g.branch.find("a").attr("href"),"https://bitbucket.org/fusiontestaccount/ddd-one/branch/"+encodeURIComponent(h),"Branch content has a link");if(_.contains(c,j)){ok(_.isEmpty(g.pullRequest.text()),"Pullrequest column is empty")}else{ok(!_.isEmpty(g.pullRequest.text()),"Pullrequest column is not empty")}ok(!_.isEmpty(g.action.text()),"Action column is not empty");ok(g.action.find("a")!=null,"Action content is a link");ok(g.action.find("a").attr("href").indexOf("https://bitbucket.org/fusiontestaccount/ddd-one/pull-request/new")!==-1,"Action content has a link")});ok(!_.isObject(a.activePullRequestsToolTip),"PullRequestsToolTip is NOT created when the pull request link is NOT hovered");d.getColumns(d.getRows()[1]).pullRequest.find(".pullrequest-tooltip").mouseenter().mousemove();ok(_.isObject(a.activePullRequestsToolTip),"PullRequestsToolTip is created when the pull request link is hovered");var e=d.getPullRequestInlineDialog(a.activePullRequestsToolTip.$content);equal(e.rowsElement.length,3,"number of statuses in tooltip is correct");deepEqual(e.rowsValue(),[{name:"#6 DEV-1 everything is nice and good and i did not forget to add issue key to commit message and PR title",state:"OPEN"},{name:"#5 DEV-1 everything is nice and good and i did not forget to add issue key to commit message and PR title",state:"MERGED"},{name:"#4 DEV-1 everything is nice and good and i did not forget to add issue key to commit message and PR title",state:"DECLINED"}],"tooltip content is correct");d.getColumns(d.getRows()[1]).pullRequest.find(".pullrequest-tooltip").mouseleave();ok(!a.activePullRequestsToolTip.visible,"PullRequestsToolTip is hidden when mouse is removed")});test("Test detail branch dialog with last commit details",function(){var a=this.createView(3);a.show();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-lastCommit",this.server.requests[1]);var b=this.getDetailDialog();equal(b.getRows().length,1,"Rendered rows");var c=b.getRows()[0];equal(b.getColumns(c).lastUpdated.attr("datetime"),"1385729932000");equal(b.getLinks(c).changeset.text(),"1f79b9a");equal(b.getLinks(c).changeset.attr("href"),"http://lpater-dev:8060/foo/changelog/gitsample?cs=1f79b9a3f334ee9db41d30193a3b3ceae7da7899");ok(!b.getColumns(c).action.length);ok(!b.getColumns(c).pullRequest.length)});test("Test getting branch features",function(){var c=this.createView(3),f=[{}],b=[{pullRequestState:{total:1}}],e=[{lastCommit:{displayId:"faf",authorTimestamp:"abc"}}],a=[{lastCommit:{displayId:"faf"}}],d=[{lastCommit:{displayId:"faf",authorTimestamp:"abc"},createPullRequestUrl:"http://foo"}];noFeatures=c._getBranchFeatures(f);pullRequests=c._getBranchFeatures(b);commits=c._getBranchFeatures(e);commitsWithIdsOnly=c._getBranchFeatures(a);commitsAndPullRequests=c._getBranchFeatures(d);ok(!noFeatures.lastCommitId);ok(!noFeatures.lastCommitTimestamp);ok(!noFeatures.pullRequests);ok(!pullRequests.lastCommitId);ok(!pullRequests.lastCommitTimestamp);ok(pullRequests.pullRequests);ok(commits.lastCommitId);ok(commits.lastCommitTimestamp);ok(!commits.pullRequests);ok(commitsWithIdsOnly.lastCommitId);ok(!commitsWithIdsOnly.lastCommitTimestamp);ok(!commitsWithIdsOnly.pullRequests);ok(commitsAndPullRequests.lastCommitId);ok(commitsAndPullRequests.lastCommitTimestamp);ok(commitsAndPullRequests.pullRequests)});test("Test analytics for branch detail dialog",function(){expect(1+(6*2*5));var d=this.createView(4);d.show();var h=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]);AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]);equal(h.getRows().length,5,"Number of branch rows rendered into the table is correct");function e(j,i,k){ok(j,k);ok(i,k)}function c(i,n){var l=JIRA.DevStatus.BranchesAnalytics[i].getCall(n);var k=_.isObject(l);var j=k&&l.calledWith("bitbucket");var m="Analytic event is fired for "+i+" link on row "+(n+1);e(k,j,m)}function g(o,k){var i=JIRA.DevStatus.BranchesAnalytics.fireDetailPullRequestLozengeClick;var m=i.called;var j=m&&i.calledWith("bitbucket");var l="";if(k){m=!m;j=!j;l=" NOT"}var n="Analytics for pull request click is"+l+" called for row "+(o+1);e(m,j,n);i.reset()}function b(m,j,l){var i=JIRA.DevStatus.BranchesAnalytics.fireDetailCreatePullRequestClicked;var k="Analytics for create pull request is called for row "+(m+1)+" ("+j+", "+l+")";e(i.called,i.calledWith("bitbucket",j,l),k);i.reset()}var a=this;var f=[0];_.each(h.getRows(),function(j,k){var i=h.getLinks(j);i.repository.click();c("fireDetailRepoClicked",k);i.branch.click();c("fireDetailBranchClicked",k);i.pullRequest.click();g(k,_.contains(f,k));a.setAnalyticsDataForView(true);i.createPullRequest.click();b(k,true);a.setAnalyticsDataForView(false,true);i.createPullRequest.click();b(k,false,true);a.setAnalyticsDataForView(false,false);i.createPullRequest.click();b(k,false,false)})});