AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");module("JIRA.DevStatus.BaseDetailDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.issueKey="AWESOME-1";this.model=this._mockOfClass(JIRA.DevStatus.BaseDetailDialogModel);JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Summary",this.sandbox)},teardown:function(){this.sandbox.restore();JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();AJS.$("body").css("overflow","initial")},getDevStatusDetailDialog:function(){var a=AJS.$(".jira-dialog");return{content:a.find(".devstatus-dialog-content"),footer:a.find(".buttons-container.form-footer"),getUnableToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all").text()}}},createView:function(b){if(!b){b={}}var a=new JIRA.DevStatus.BaseDetailDialogView(b);a.analytics=JIRA.DevStatus.SummaryAnalytics;return a},createDefaultView:function(a){return this.createView({type:"commit",model:this.model,count:a||2,issueKey:this.issueKey})},_mockOfClass:function(b){var a={};_.each(_.functions(b.prototype),function(c){a[c]=sinon.stub()});return a},assertVisible:function(b,a){ok(b.is(":visible")&&!b.hasClass("hidden"),a)},assertInvisible:function(b,a){ok(!b.is(":visible")||b.hasClass("hidden"),a)},defaultTabOrder:["bitbucket","fecru","stash"],defaultTabs:{bitbucket:{count:5000,name:"Bitbucket"},fecru:{count:1,name:"Fisheye / Crucible"},stash:{count:99,name:"Stash"}},sourceStash1:{typeName:"Stash",type:"stash",name:"Stash Dev One",baseUrl:"https://stash1.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc91"},sourceStash2:{typeName:"Stash",type:"stash",name:"Stash Dev Two",baseUrl:"https://stash2.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc92"},sourceStash3:{typeName:"Stash",type:"stash",name:"Stash Dev Three",baseUrl:"https://stash3.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc93"},sourceStash4:{typeName:"Stash",type:"stash",name:"Stash Dev Four",baseUrl:"https://stash4.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc94"}});test("Test default values are set when not provided",function(){var a=this.createView();ok(_.isObject(a.model),"A detail dialog model is created if not provided");ok(a.options.width!=null,"Width parameter is defined if not provided")});test("Test default values are NOT set when width is provided",function(){view=this.createView({model:this.model,width:9000});equal(view.model,this.model,"Provided dialog model parameter is respected");equal(view.options.width,9000,"Provided width parameter is respected")});test("Tabs are ordered and keep data attributes",function(){this.model.get.withArgs("tabs").returns({y:{foo:10},a:{},z:{bar:20},b:{}});console.log(this.createDefaultView()._convertTabsForSoy());deepEqual(this.createDefaultView()._convertTabsForSoy(),[{type:"a"},{type:"b"},{type:"y",foo:10},{type:"z",bar:20}])});test("Tabs are not rendered when there is only one product",function(){var a={bitbucket:{count:5000}};this.model.get.withArgs("tabs").returns(a);var b=this.createDefaultView(1);b.show();ok(this.model.switchTab.calledWith("bitbucket"),"The initial ajax call is made on show()");var c=this.getDevStatusDetailDialog();var d=c.content.find(".tabs-menu");equal(d.find(".menu-item").length,1,"There is only one tab");ok(d!=null,"Tabs menu element exist");this.assertInvisible(d,"Tabs menu is not visible")});test("Tabs are rendered when there are more than one product",function(){expect(13);var b=this;var d=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView(99999);c.show();ok(this.model.switchTab.calledWith("bitbucket"),"The initial ajax call is made on show()");var e=this.getDevStatusDetailDialog();var g=e.content.find(".tabs-menu");var f=g.find(".menu-item");ok(g!=null,"Tabs menu element exist");this.assertVisible(g,"Tabs menu is visible");equal(f.length,3,"There are three tabs");_.each(f,function(i,h){var k=d[h];var j=AJS.$(i);equal(j.text(),a[k].name+a[k].count,"Tabs content is correct with app name + count");j.children().click();ok(b.model.switchTab.calledWith(k,false),"Tab clicks are propagated properly back to the model without forceFetch");b.model.switchTab.reset()});c.shouldRefreshOnTabSwitch=function(){return true};_.each(f,function(i,h){var k=d[h];var j=AJS.$(i);j.children().click();ok(b.model.switchTab.calledWith(k,true),"Tab clicks are propagated properly back to the model with forceFetch");b.model.switchTab.reset()})});test("Tabs are rendered when switched away before data is back",function(){expect(7);var b=this;var d=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView(99999);c.show();ok(this.model.switchTab.calledWith("bitbucket"),"The initial ajax call is made on show()");c.renderSuccess=sinon.stub();c._renderError=sinon.stub();c._handleFetchSucceeded("stash",{detail:["stash-data"]});ok(c.renderSuccess.calledWith("stash",["stash-data"]),"stash pane is rendered first");ok(c._renderError.calledWith("stash",undefined,true),"error is handled on stash first");c._handleFetchSucceeded("bitbucket",{detail:["bb-data1","bb-data2"],errors:"error"});ok(c.renderSuccess.calledWith("bitbucket",["bb-data1","bb-data2"]),"bitbucket pane is rendered later");ok(c._renderError.calledWith("bitbucket","error",true),"error is handled on bitbucket later");c._handleFetchSucceeded("fecru",{detail:[],errors:"error"});ok(c.renderSuccess.neverCalledWith("fecru",undefined),"fecru pane is NOT rendered");ok(c._renderError.calledWith("fecru","error",false),"error is handled on bitbucket later")});test("Authentication status footer is not rendered when no errors",function(){expect(3);var b=this;var d=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var f=[{source:this.sourceStash1,authenticated:true,configured:true}];c._handleAuthSucceeded(f);var e=this.getDevStatusDetailDialog();var g=e.footer.find(".oauth-status");ok(g!=null&&g.length>0,"Status div element exist");this.assertInvisible(g,"Status div is not visible")});test("Authentication status footer is rendered when there is one auth error",function(){expect(6);var b=this;var e=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var g=[{source:this.sourceStash1,authenticated:false,configured:true}];c._handleAuthSucceeded(g);var f=this.getDevStatusDetailDialog();var h=f.footer.find(".oauth-status");ok(h!=null&&h.length>0,"Status div element exist");this.assertVisible(h,"Status div is visible");ok(h.text().indexOf("You might be able to see more information by authenticating with the following application:")>=0,"Status div contains right message title");var d=h.find(".instance");equal(d.length,1,"One unauth instance is shown");ok(d.text(),this.sourceStash1.name,"Unauth instance name is correct")});test("Authentication screen shown when there is no data",function(){expect(2);var a=this.createDefaultView();a.renderSuccess=sinon.stub();a._renderNoPermissionToViewAllWarning=sinon.stub();a._handleFetchSucceeded("stash",{detail:[]});ok(a.renderSuccess.neverCalledWith("stash",["stash-data"]),"stash pane is rendered first");ok(a._renderNoPermissionToViewAllWarning.calledWith("stash"),"No Permission called")});test("Authentication screen not shown when there is data",function(){expect(2);var a=this.createDefaultView();a.renderSuccess=sinon.stub();a._renderNoPermissionToViewAllWarning=sinon.stub();a._handleFetchSucceeded("stash",{detail:["things"]});ok(a.renderSuccess.calledWith("stash",["things"]),"stash pane is rendered first");ok(a._renderNoPermissionToViewAllWarning.neverCalledWith("stash"),"No Permission called")});test("Authentication screen not shown when hasData overridden",function(){expect(2);var a=this.createDefaultView();a.renderSuccess=sinon.stub();a._renderNoPermissionToViewAllWarning=sinon.stub();a.hasData=function(){return false};a._handleFetchSucceeded("stash",{detail:["things"]});ok(a.renderSuccess.neverCalledWith("stash",["things"]),"stash pane is rendered first");ok(a._renderNoPermissionToViewAllWarning.calledWith("stash"),"No Permission called")});test("Authentication status footer is NOT rendered when there is one incorrectly configured link with auth error",function(){expect(3);var b=this;var d=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var f=[{source:this.sourceStash1,authenticated:false,configured:false}];c._handleAuthSucceeded(f);var e=this.getDevStatusDetailDialog();var g=e.footer.find(".oauth-status");ok(g!=null&&g.length>0,"Status div element exist");this.assertInvisible(g,"Status div is not visible")});test("Authentication status footer is rendered when there is one auth error with non-errors",function(){expect(6);var b=this;var e=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var g=[{source:this.sourceStash2,authenticated:true,configured:true},{source:this.sourceStash1,authenticated:false,configured:true},{source:this.sourceStash3,authenticated:true,configured:true}];c._handleAuthSucceeded(g);var f=this.getDevStatusDetailDialog();var h=f.footer.find(".oauth-status");ok(h!=null&&h.length>0,"Status div element exist");this.assertVisible(h,"Status div is visible");ok(h.text().indexOf("You might be able to see more information by authenticating with the following application:")>=0,"Status div contains right message title");var d=h.find(".instance");equal(d.length,1,"One unauth instance is shown");ok(d.text(),this.sourceStash1.name,"Unauth instance name is correct")});test("Authentication status footer is NOT rendered when there is one incorrectly configured link with other correctly configured links",function(){expect(3);var b=this;var d=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var f=[{source:this.sourceStash2,authenticated:true,configured:true},{source:this.sourceStash1,authenticated:false,configured:false},{source:this.sourceStash3,authenticated:true,configured:true}];c._handleAuthSucceeded(f);var e=this.getDevStatusDetailDialog();var g=e.footer.find(".oauth-status");ok(g!=null&&g.length>0,"Status div element exist");this.assertInvisible(g,"Status div is not visible")});test("Authentication status footer is rendered when there is one incorrectly configured link with other correctly configured links, but with auth error",function(){expect(6);var b=this;var e=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var g=[{source:this.sourceStash2,authenticated:true,configured:true},{source:this.sourceStash1,authenticated:false,configured:false},{source:this.sourceStash3,authenticated:false,configured:true}];c._handleAuthSucceeded(g);var f=this.getDevStatusDetailDialog();var h=f.footer.find(".oauth-status");ok(h!=null&&h.length>0,"Status div element exist");this.assertVisible(h,"Status div is visible");ok(h.text().indexOf("You might be able to see more information by authenticating with the following application:")>=0,"Status div contains right message title");var d=h.find(".instance");equal(d.length,1,"One unauth instance is shown");ok(d.text(),this.sourceStash1.name,"Unauth instance name is correct")});test("Authentication status footer is rendered when there are two auth errors",function(){expect(6);var b=this;var e=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView();c.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var g=[{source:this.sourceStash1,authenticated:false,configured:true},{source:this.sourceStash2,authenticated:false,configured:true}];c._handleAuthSucceeded(g);var f=this.getDevStatusDetailDialog();var h=f.footer.find(".oauth-status");ok(h!=null&&h.length>0,"Status div element exist");this.assertVisible(h,"Status div is visible");ok(h.text().indexOf("You might be able to see more information by authenticating with the following applications:")>=0,"Status div contains right message title");var d=h.find(".instance");equal(d.length,2,"Two unauth instances are shown");equal(d.text(),this.sourceStash1.name+this.sourceStash2.name,"Unauth instance names are correct")});test("Authentication status footer is rendered when there are three auth errors",JIRA.DevStatus.QunitTestUtils.withFakeTimer(function(e){expect(11);var l=this;var a=this.defaultTabOrder;var h=this.defaultTabs;this.model.get.withArgs("tabs").returns(h);var j=this.createDefaultView();j.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var b=[{source:this.sourceStash1,authenticated:false,configured:true},{source:this.sourceStash2,authenticated:false,configured:true},{source:this.sourceStash3,authenticated:false,configured:true}];j._handleAuthSucceeded(b);var i=this.getDevStatusDetailDialog();var d=i.footer.find(".oauth-status");ok(d!=null&&d.length>0,"Status div element exist");this.assertVisible(d,"Status div is visible");ok(d.text().indexOf("You might be able to see more information by authenticating with the following applications:")>=0,"Status div contains right message title");var f=d.find(".instance");equal(f.length,2,"Two unauth instances are shown");equal(f.text(),this.sourceStash1.name+this.sourceStash2.name,"Shown unauth instance names are correct");var k=d.find(".more-instances");equal(k.length,1,"The link for more unauth instances is shown");k.click();e.tick(1);var c=AJS.$(document).find("#inline-dialog-instance-list-popup");equal(c.length,1,"Inline dialog for more instances is created");this.assertVisible(c,"Inline dialog is visible after clicking on more link");var g=c.find(".instance");equal(g.length,1,"One instance in the inline dialog");equal(g.text(),this.sourceStash3.name,"Shown unauth instance name in popup is correct")}));test("Authentication status footer is rendered when there are four auth errors",JIRA.DevStatus.QunitTestUtils.withFakeTimer(function(e){expect(11);var l=this;var a=this.defaultTabOrder;var h=this.defaultTabs;this.model.get.withArgs("tabs").returns(h);var j=this.createDefaultView();j.show();ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var b=[{source:this.sourceStash1,authenticated:false,configured:true},{source:this.sourceStash2,authenticated:false,configured:true},{source:this.sourceStash3,authenticated:false,configured:true},{source:this.sourceStash4,authenticated:false,configured:true}];j._handleAuthSucceeded(b);var i=this.getDevStatusDetailDialog();var d=i.footer.find(".oauth-status");ok(d!=null&&d.length>0,"Status div element exist");this.assertVisible(d,"Status div is visible");ok(d.text().indexOf("You might be able to see more information by authenticating with the following applications:")>=0,"Status div contains right message title");var f=d.find(".instance");equal(f.length,2,"Two unauth instances are shown");equal(f.text(),this.sourceStash1.name+this.sourceStash2.name,"Shown unauth instance names are correct");var k=d.find(".more-instances");equal(k.length,1,"The link for more unauth instances is shown");k.click();e.tick(1);var c=AJS.$(document).find("#inline-dialog-instance-list-popup");equal(c.length,1,"Inline dialog for more instances is created");this.assertVisible(c,"Inline dialog is visible after clicking on more link");var g=c.find(".instance");equal(g.length,2,"Two instances in the inline dialog");equal(g.text(),this.sourceStash3.name+this.sourceStash4.name,"Shown unauth instance names in popup are correct")}));test("Test analytics are fired when clicked on product tab",function(){expect(1+(3*3));var b=this;var d=this.defaultTabOrder;var a=this.defaultTabs;this.model.get.withArgs("tabs").returns(a);var c=this.createDefaultView(99999);c.show();var e=this.getDevStatusDetailDialog().content.find(".tabs-menu").find(".menu-item");equal(e.length,3,"There are three tabs");_.each(e,function(g,f){var i=d[f];var h=AJS.$(g);h.children().click();ok(b.model.switchTab.calledWith(i,false),"Tab clicks are propagated properly back to the model without forceFetch");ok(JIRA.DevStatus.SummaryAnalytics.fireDetailTabClicked.called,"Analytic event is fired correctly when clicking on product tab in detail dialog");ok(JIRA.DevStatus.SummaryAnalytics.fireDetailTabClicked.calledWith(i,undefined),"Analytic event is fired correctly when clicking on product tab in detail dialog");b.model.switchTab.reset()})});test("Test sanitised pane id",function(){var c="bad.id";var b={};b[c]={count:1,name:"Invalid"};this.model.get.withArgs("tabs").returns(b);var a=this.createDefaultView(99999);a.show();ok(a._getPane(c).length===1)});test("Anon user always see a message to login if count is different regardless of error case",function(){var b={};var c=this.sandbox.stub(JIRA.Users.LoggedInUser,"isAnonymous");this.model.get.withArgs("tabs").returns(this.defaultTabs);var a=this.createDefaultView();a.show();this.model.get.withArgs("contentMap").returns({stash:{}});c.returns(false);a.renderNoPermissionToViewAllWarningAtBottom("stash",1);equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"Unable to retrieve development information Please contact your administrator.");a.getContentContainer("stash").empty();this.model.get.withArgs("contentMap").returns({stash:{}});c.returns(true);a.renderNoPermissionToViewAllWarningAtBottom("stash",1);equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"Unable to retrieve development information You might be able to view more by authenticating with JIRA.");a.getContentContainer("stash").empty();this.model.get.withArgs("contentMap").returns({stash:{errors:{empty:false}}});c.returns(false);a.renderNoPermissionToViewAllWarningAtBottom("stash",1);equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"");a.getContentContainer("stash").empty();this.model.get.withArgs("contentMap").returns({stash:{errors:{empty:false}}});c.returns(true);a.renderNoPermissionToViewAllWarningAtBottom("stash",1);equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"Unable to retrieve development information You might be able to view more by authenticating with JIRA.");a.getContentContainer("stash").empty()});test("Incapable error is not shown in detail dialog",function(){expect(4*4);this.model.get.withArgs("tabs").returns(this.defaultTabs);var b=this.createDefaultView(99999);b.show();var a="bitbucket";var d=[{error:"unathorized",instance:{baseUrl:"sss",name:"squirtle"}},{error:"random",instance:{baseUrl:"ccc",name:"charmander"}},{error:"incapable",instance:{baseUrl:"ppp",name:"pikachu"}}];function c(){var e=b.getContentContainer(a);var f=e.find(".instance");ok(f.length===2);equal(f.eq(0).text(),"squirtle");equal(f.eq(1).text(),"charmander");ok(e.text().indexOf("pikachu")===-1,"There is no mention of the incapable instance at all in detail dialog")}_.each([true,false],function(e){_.each([true,false],function(f){b._renderError(a,d,e,f);c();b.getContentContainer(a).empty()})})});