Backbone.define("JIRA.DevStatus.BaseDetailDialogView",Backbone.View.extend({frameEvents:{"click .menu-item":"_doTabClick"},frameTemplate:JIRA.Templates.DevStatus.DetailDialog.frame,oauthStatusTemplate:JIRA.Templates.DevStatus.DetailDialog.oauthStatus,authenticationTemplate:JIRA.Templates.DevStatus.DetailDialog.authenticationScreen,connectionProblemTemplate:JIRA.Templates.DevStatus.DetailDialog.connectionProblemScreen,connectionProblemWarningTemplate:JIRA.Templates.DevStatus.connectionProblemAsWarning,noPermissionToViewAllTemplate:JIRA.Templates.DevStatus.DetailDialog.noPermissionToViewAll,initialize:function(a){this.options=_.defaults({},a,{width:560,model:new JIRA.DevStatus.BaseDetailDialogModel(a)});this.model=this.options.model;this._initFetchHandlers();this._initFormDialog()},renderSuccess:function(b,a){return this},shouldRefreshOnTabSwitch:function(a){return false},getTitle:function(b,a){console.warn("Unimplemented getTitle() function",this);return a},getOAuthMessageInFooter:function(a){return AJS.I18n.getText("devstatus.authentication.message.generic",a.length)},getOAuthMessageInCanvas:function(){return AJS.I18n.getText("devstatus.authentication.authenticate.generic.title")},getConnectionMessageInCanvas:function(){return AJS.I18n.getText("devstatus.authentication.connection-problem.generic.title")},getNoPermissionToViewAllMessageInCanvas:function(){return AJS.I18n.getText("devstatus.authentication.connection-problem.generic.title")},getContactAdmistratorsOrLoginMessageInCanvas:function(){if(JIRA.Users.LoggedInUser.isAnonymous()){return AJS.I18n.getText("devstatus.authentication.no-permission-to-view-all.generic.login")}else{return AJS.I18n.getText("devstatus.authentication.no-permission-to-view-all.generic.admin-contact")}},hasData:function(a){return a.length>0},show:function(){this.dialog.show()},hide:function(){this.dialog.hide()},_getPane:function(a){return a?this.$el.find("#tab-content-"+a.replace(/(:|\.|\[|\])/g,"\\$1")):AJS.$()},getContentContainer:function(a){return this._getPane(a||this._getActiveApplicationType()).find(".detail-content-container")},_doTabClick:function(b){b.preventDefault();var a=this._getActiveApplicationType();this.model.switchTab(a,this.shouldRefreshOnTabSwitch(a));this.analytics&&this.analytics.fireDetailTabClicked(a)},_redirectToLoginIf401:function(a){if(a&&a.status===401){JIRA.DevStatus.Navigate.redirectToLogin();return true}return false},_initFetchHandlers:function(){this.model.on("fetchRequested",this._showLoadingIndicator,this);this.model.on("fetchSucceeded",this._handleFetchSucceeded,this);this.model.on("fetchFailed",this._handleFetchFailed,this)},_handleFetchSucceeded:function(c,a){this._hideLoadingIndicator(c);var b=a.detail&&this.hasData(a.detail);if(b){this.renderSuccess(c,a.detail)}this._renderError(c,a.errors,b);this._postRender()},_handleFetchFailed:function(b,a){this._hideLoadingIndicator(b);if(!this._redirectToLoginIf401(a)){this._renderError(b,[],false,true)}},_initAuthenticationCallbacks:function(){this._patchAJSIconsForAppLinks();var a=this;var d=function(g,f){a.model.oauthStatusChanged(f.appType);a.model.fetchAuthenticationStatuses();g.preventDefault()};var c=function(g,f){AJS.$.ajax(AJS.contextPath()+"/rest/auth/1/session").promise().fail(function(e){a._redirectToLoginIf401(e)})};var b=AJS.$(document);b.bind("applinks.auth.approved",d);b.bind("applinks.auth.denied",c);AJS.$(this.dialog).bind("Dialog.beforeHide",function(){b.unbind("applinks.auth.approved",d);b.unbind("applinks.auth.denied",c);a.instanceListPopup&&a.instanceListPopup.remove()});AJS.$('<div class="applinks-auth-confirmation-container hidden"></div>').appendTo(this.$el)},_initFetchAuthenticationHandlers:function(){this.model.on("fetchAuthRequested",this._showLoadingIndicator,this);this.model.on("fetchAuthSucceeded",this._handleAuthSucceeded,this);this.model.on("fetchAuthFailed",this._handleAuthFailed,this)},_handleAuthSucceeded:function(b){var a=this;var d=_.filter(b,function(e){return e.configured&&!e.authenticated&&e.source&&e.source.applicationLinkId});var c=this._getOAuthStatusDiv();if(d.length>0&&!JIRA.Users.LoggedInUser.isAnonymous()){c.html(this.oauthStatusTemplate({message:this.getOAuthMessageInFooter(d)}));this._renderUnauthInstancesInFooter(d);c.show()}else{c.hide()}},_handleAuthFailed:function(a){this._redirectToLoginIf401(a);this._getOAuthStatusDiv().hide()},_renderUnauthInstancesInFooter:function(c){var b=this._getOAuthStatusDiv();var d=_.map(_.pluck(c,"source"),this._createOAuthInstanceDiv);if(d.length>0){b.append(d[0]);if(d.length>1){b.append(", ");b.append(d[1]);if(d.length>2){b.append(" ");var e=AJS.$('<span class="more-instances"><a href="#">'+AJS.I18n.getText("devstatus.authentication.message.more.link")+"</a></span>");b.append(e);var a=AJS.$('<ul class="instance-list"></ul>');_.each(d.slice(2),function(f){a.append(AJS.$('<li class="instance-in-popup"></li>').append(f))});AJS.InlineDialog(e,"instance-list-popup",function(g,f,h){g.html(a);h();return false},{width:150,offsetX:-100,onTop:true})}}}},_createOAuthInstanceDiv:function(a){var b=ApplinksUtils.createAuthRequestInline(null,{id:a.applicationLinkId,authUri:AJS.contextPath()+"/plugins/servlet/applinks/oauth/login-dance/authorize?applicationLinkID="+encodeURIComponent(a.applicationLinkId),appUri:a.baseUrl,appName:a.name,appType:a.type});return AJS.$('<span class="instance"></span>').append(b.find("a.applink-authenticate").text(a.name))},_patchAJSIconsForAppLinks:function(){AJS.icons=AJS.icons||{};AJS.icons.addIcon=AJS.icons.addIcon||{};AJS.icons.addIcon.init=AJS.icons.addIcon.init||function(){}},_getOAuthStatusDiv:function(){var a=this.$el.find(".buttons-container .oauth-status");if(a.length){return a}else{return AJS.$('<div class="oauth-status" />').appendTo(this.$el.find(".buttons-container.form-footer"))}},_renderError:function(f,g,d,c){var a=_.groupBy(g,function(h){var i=h.error;if(i==="unauthorized"||i==="incapable"){return i}else{return"others"}});var b=_.pluck(a.unauthorized,"instance");var e=_.pluck(a.others,"instance");if(b.length>0){this.model.fetchAuthenticationStatuses()}if(d){if(e.length>0){this._renderConnectionErrorBeforeData(f,e)}}else{if(b.length>0){this._renderAuthenticationError(f,b,e)}else{if(c||e.length>0){this._renderConnectionError(f,e)}else{this._renderNoPermissionToViewAllWarning(f)}}}},_renderConnectionErrorBeforeData:function(b,a){this.getContentContainer(b).prepend(this.connectionProblemWarningTemplate({instances:a,showContactAdminForm:this.options.showContactAdminForm}))},_renderConnectionError:function(b,a){this.getContentContainer(b).html(this.connectionProblemTemplate({instances:a,title:this.getConnectionMessageInCanvas(),showContactAdminForm:this.options.showContactAdminForm}))},renderNoPermissionToViewAllWarningAtBottom:function(c,d){var a=this.model.get("tabs")[c]||{};var b=this.model.get("contentMap")[c]||{};if(d<a.count){if((b.errors||[]).length===0||JIRA.Users.LoggedInUser.isAnonymous()){this.getContentContainer(c).append(this._getNoPermissionToViewAllHtml())}}},_getNoPermissionToViewAllHtml:function(){return this.noPermissionToViewAllTemplate({message:this.getNoPermissionToViewAllMessageInCanvas(),secondaryMessage:this.getContactAdmistratorsOrLoginMessageInCanvas()})},_renderNoPermissionToViewAllWarning:function(a){this.getContentContainer(a).html(this._getNoPermissionToViewAllHtml())},_renderAuthenticationError:function(f,c,e){var a=this.getContentContainer(f);a.html(this.authenticationTemplate({unauthInstances:c,title:this.getOAuthMessageInCanvas(),otherInstances:e,showContactAdminForm:this.options.showContactAdminForm}));var d=_.map(c,this._createOAuthInstanceDiv);var b=a.find(".instances");_.each(d,function(h,g){if(g!==0){b.append(", ")}b.append(h)})},_initFormDialog:function(){var a=this;this.dialog=new JIRA.FormDialog({id:this.options.id,width:this.options.width,content:function(b){a.setElement(this.$popup);a.delegateEvents(_.extend({},a.frameEvents,a.events));a._renderFrame();a._initAuthenticationCallbacks();a._initFetchAuthenticationHandlers();a.model.fetchAuthenticationStatuses();a.model.switchTab(a._getActiveApplicationType());b()},autoClose:true})},_postRender:function(){this.$el.find(".extra-content-in-title").tooltip();this.dialog._positionInCenter();this.$el.find(".active-pane a:eq(0)").focus()},_getActiveApplicationType:function(){return this.$el.find(".menu-item.active-tab").data("applicationType")},_showLoadingIndicator:function(c){var a=this._getPane(c);a._removeClass("ready");a.addClass("loading");var b=a.find(".status-loading");b.spin("large");b.show()},_hideLoadingIndicator:function(c){var a=this._getPane(c);a.addClass("ready");var b=a.find(".status-loading");if(b){a.removeClass("loading");b.hide();b.spinStop()}},_renderFrame:function(){this.$el.html(this.frameTemplate({title:this.getTitle(this.options.count,this.options.issueKey),tabs:this._convertTabsForSoy(),initialTab:this.options.initialTab}));if(this.options.height){this.$el.find(".form-body").css("min-height",this.options.height)}},_convertTabsForSoy:function(){return _.chain(this.model.get("tabs")).map(function(b,a){return _.extend({type:a},b)}).sortBy(function(a){return a.type}).value()},_createReviewersInlineDialog:function(){this.reviewerInlineDialogView=new JIRA.DevStatus.ReviewerInlineDialogView({el:this.$el.find(".extrareviewers-tooltip"),});return this.reviewerInlineDialogView},_removeInlineDialog:function(a){if(this[a]){this[a].hide();this[a].remove();this[a]=undefined}}}));