(function() {
    JIRA.DevStatus.setDetailDialogParam = function() {
        AJS.Meta.set("fusion-open-detail-dialog", JIRA.DevStatus.URL.getDetailDialogParam());
    };
    /**
     * Attempt to get the summary type data from url parameter to automatically open the detail dialog.
     *
     * This is done on 'page load' as opposed to 'document ready' because KickAss will immediately strip off
     * non-KA parameter from the URL (the only KA parameter is jql and startIndex).
     *
     * Data is stored in AJS.Meta with key "fusion-open-detail-dialog", which will be later read by DevStatusModule
     * after all summary data has been loaded
     */
    JIRA.DevStatus.setDetailDialogParam();
})();

AJS.$(function() {
    JIRA.DevStatus.showTooltip = true;

    var selectors = {
        devStatusContainer: "#devstatus-container",
        parentContainer: "[id$='devstatus-panel']",
        link: "a.devstatus-cta-link",
        statusPanel: ".status-panels",
        viewIssueHeader: ".mod-header",
        agileHeader: ".ghx-header",
        agileNavMenuLink: 'a[href="#ghx-tab-com-atlassian-jira-plugins-'
                + 'jira-development-integration-plugin-greenhopper-devstatus-panel"]'
    };

    function isDashboard(context) {
        return context.find("body").hasClass("page-type-dashboard");
    }

    function isJIRAAgile(context) {
        return context.find("body").hasClass("ghx-agile");
    }

    function isKA(context) {
        return context.find("body").hasClass("ka ajax-issue-search-and-view");
    }

    function initDevStatusPanel(container, headerSelector, visibilityToggler) {
        JIRA.DevStatus.devStatusModule.initializePanel({
            container: container,
            showTooltip: JIRA.DevStatus.showTooltip,
            headerSelector: headerSelector,
            devStatusPanelVisibilityToggler: visibilityToggler,
            phaseTwoDisabled: !AJS.DarkFeatures.isEnabled("jira.plugin.devstatus.phasetwo.enabled")
        });
    }

    function toggleDevStatusPanelVisibilityOnViewIssue(container, visible, animate, callback) {
        _.defer(function() {
            var animateDuration = animate ? 1000 : 0;

            var animationParam = {duration: animateDuration, complete: callback};
            if (visible) {
                container.slideDown(animationParam);
            } else {
                container.slideUp(animationParam);
            }
        });
    }

    // JIRA Document ready
    // We want to do 2 things:
    // 1. Always initialise the first portion of DevStatusModule for the create branch link and cta dialog
    // 2. Also initialise the full DevStatusModule if it is server rendered view issue
    JIRA.DevStatus.documentReadyInit = function (context) {
        JIRA.DevStatus.devStatusModule = new JIRA.DevStatus.DevStatusModule({
            parentContainerSelector: selectors.parentContainer,
            linkSelector: selectors.link,
            panelSelector: selectors.devStatusContainer,
            statusPanelSelector: selectors.statusPanel
        });

        if (isDashboard(context) || isJIRAAgile(context)) {
            // Note: This binds to the click event for scrolling to the dev status panel.
            // Jira Agile do not publish events for these clicks.
            // It isn't pretty, but it works.
            context.find("body").on("click", selectors.agileNavMenuLink,
                    JIRA.DevStatus.Analytics.fireAgileDevStatusLinkClicked);
            JIRA.DevStatus.showTooltip = false;
        } else if (isKA(context)) {
            if (JIRA.Issues.Api.isFullScreenIssueVisible()) {
                var container = AJS.$(selectors.devStatusContainer);
                if (container.length > 0) {
                    initDevStatusPanel(container, selectors.viewIssueHeader, toggleDevStatusPanelVisibilityOnViewIssue);
                }
            }
        }

        // JIRA View Issue
        JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context) {
            if (context.not(document).is(selectors.parentContainer)) {
                initDevStatusPanel(context.find(selectors.devStatusContainer), selectors.viewIssueHeader, toggleDevStatusPanelVisibilityOnViewIssue);
                JIRA.DevStatus.showTooltip = false;
                return true;
            }
            return false;
        });

        // JIRA Agile Detail View
        JIRA.bind("GH.DetailView.updated", function(e, data) {
            // no visibility toggler on jira agile. both the panel and the nav menu icon will always be shown.
            initDevStatusPanel(AJS.$(selectors.devStatusContainer), selectors.agileHeader);
        });
    };
    
    AJS.$(function() {
        JIRA.DevStatus.documentReadyInit(AJS.$(document));
    });
});
