/**
 * Keeps track of registered listeners for easy cleanup.
 *
 * @class JIRA.DevStatus.Util.Listeners
 */
Backbone.define('JIRA.DevStatus.Util.Listeners', Class.extend({
    init: function() {
        this._listening = [];
    },

    /**
     * Registers <code>callback</code> to listen to <code>event</code> on <code>other</code>.
     *
     * @param {Backbone.Events} other the instance to listen to
     * @param {String} event the name of the event
     * @param {Function} callback the callback
     * @param {object} context the 'this' to use for <code>callback</code>
     */
    startListening: function(other, event, callback, context) {
        var listener = {
            start: function() {
                other.on(event, callback, context);
                return this;
            },

            stop: function() {
                other.off(event, callback, context);
                return this;
            }
        };

        this._listening.push(listener.start())
    },

    /**
     * Unregisters listeners for all events.
     */
    stopListening: function() {
        _.each(this._listening, function(listener) {
            listener.stop();
        });

        this._listening = [];
    }

}));
