AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:utils");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");

module("JIRA.DevStatus.Util.Listeners", {
    setup: function() {
        this.model1 = this.mockModel();
        this.model2 = this.mockModel();

        this.listeners = new JIRA.DevStatus.Util.Listeners();
    },

    mockModel: function() {
        var model = {};
        model.on = sinon.spy();
        model.off = sinon.spy();

        return model;
    }
});

test("startListening registers a callback using Backbone.Events.on", function() {
    // set up the callback args
    var event1 = "myEvent_1", callback1 = function() {}, context1 = {};
    var event2 = "myEvent_2", callback2 = function() {}, context2 = {};

    this.listeners.startListening(this.model1, event1, callback1, context2);
    this.listeners.startListening(this.model2, event2, callback2, context2);

    ok(this.model1.on.calledOnce, "model1.on should be called once");
    ok(this.model1.on.firstCall.calledWith(event1, callback1, context1), "model1.on should be called with the right args");

    ok(this.model2.on.calledOnce, "model2.on should be called once");
    ok(this.model2.on.firstCall.calledWith(event2, callback2, context2), "model2.on should be called with the right args");
});

test("stopListening unregisters all callbacks using Backbone.Events.off", function() {
    // set up the callback args
    var event1 = "myEvent_1", callback1 = function() {}, context1 = {};
    var event2 = "myEvent_2", callback2 = function() {}, context2 = {};

    this.listeners.startListening(this.model1, event1, callback1, context1);
    this.listeners.startListening(this.model2, event2, callback2, context2);
    this.listeners.stopListening();

    ok(this.model1.off.calledOnce, "model1.off should be called once");
    ok(this.model1.off.firstCall.calledWith(event1, callback1, context1), "model1.off should be called with the right args");

    ok(this.model2.off.calledOnce, "model2.off should be called once");
    ok(this.model2.off.firstCall.calledWith(event2, callback2, context2), "model2.off should be called with the right args");
});
