(function ($){
    AJS.namespace('JIRA.DevStatus.URL');
    JIRA.DevStatus.URL = {
        getDetailDialogParam: function() {
            var url = this._removeKickAssIHashFromUrl(JIRA.DevStatus.Navigate.getUrl());
            var parsedUri = parseUri(url);
            return parsedUri && parsedUri.queryKey && parsedUri.queryKey["devStatusDetailDialog"];
        },
        getUrlWithDetailDialogParam: function(summaryType) {
            var currentUrl = this._removeKickAssIHashFromUrl(JIRA.DevStatus.Navigate.getUrl());
            var parsedUri = parseUri(currentUrl);

            /**
             * Insert/replace devStatusDetailDialog param/query into the url
             */
            parsedUri.queryKey["devStatusDetailDialog"] = encodeURIComponent(summaryType);
            return this._createUrlFromParsedUri(parsedUri);
        },

        getCreateReviewDetailUrl: function(applicationType) {
            return this.getUrlWithDetailDialogParam("create-review-" + applicationType)
        },

        isCreateReviewDetailDialogLink: function(dialogToOpen) {
            return dialogToOpen && dialogToOpen.lastIndexOf && dialogToOpen.lastIndexOf("create-review-", 0) === 0
        },

        getCreateReviewDetailDialogApplicationType: function(dialogToOpen) {
            return dialogToOpen.substring("create-review-".length);
        },

        _removeKickAssIHashFromUrl: function(url) {
            /**
             * In order to support single page app behaviour for issue nav/view issue in IE,
             * KickAss appended 'i#' prefix between the base URL and the KA url, because IE doesn't support push state
             * For example: http://localhost:2990/jira/i#browse/DEV-1
             *
             * parseUri and the logic in getUrlWithDetailDialogParam simply wouldn't work with an URL format like the above,
             * instead, we need to remove the i# prefix to get the regular non-IE-specific URL
             *
             * KA will automatically redirect from a regular URL to a i# url for IE.
             */
            return url.replace("i#", "");
        },
        /**
         * Copied from JIRA Agile.
         * See https://stash.atlassian.com/projects/JAG/repos/jira-agile/browse/greenhopper/src/main/resources/includes/js/lib/ajs-future.js#118
         *
         * Transformed the uri object from {@code parseUri} into url string
         *
         * @param uri object from {@code parseUri}
         * @returns {string}
         */
        _createUrlFromParsedUri: function(uri) {
            var params = [];
            AJS.$.each(uri.queryKey, function (name, value) {
                if(_.isObject(value)) {
                    AJS.$.each(value, function(index, innerVal) {
                        params.push(name + "=" + innerVal);
                    });
                } else {
                    params.push(name + "=" + value);
                }
            });

            var url = "";
            if (uri.protocol) {
                url += uri.protocol + "://";
            } if (uri.authority) {
                url += uri.authority;
            } if (uri.path) {
                url += uri.path;
            } if (params.length > 0) {
                url += "?" + params.join("&");
            } if (uri.anchor) {
                url += "#" + uri.anchor;
            }
            return url;
        }
    };
}(AJS.$));
