/**
 * This file should be included first within the JS batch, but this can not be guaranteed to always happen
 */
if (!JIRA.DevStatus) {
    AJS.namespace("JIRA.DevStatus");
}

/**
 * This is an attempt to avoid direct interaction with the 'window' object in Javascript land.
 * This also includes all interactions with objects such as 'location' or 'document', because they are simply a reference
 *    from 'window.location' and 'window.document' respectively.
 *
 * There are 2 main reasons for doing this:
 * 1. To allow the JS code to be QUnit testable. 'window' object is not mock-able, hence does not respond well
 *    when testing modules that refresh or navigate away from the page.
 * 2. To avoid the incident where important JS events are not run when the browser navigates away from the current page.
 *    This will allow the currently queue-ed up events to be completed first before the browser trashes the Javascript state
 *    and navigates away.
 */
JIRA.DevStatus.Navigate = {
    getUrl: function() {
        return window.location.href;
    },
    reload: function() {
        _.defer(function() {
            window.location.reload();
        });
    },
    navigate: function(url) {
        _.defer(function() {
            window.location = url;
        });
    },
    redirectToLogin: function() {
        this.navigate(AJS.contextPath() + '/login.jsp?permissionViolation=true&os_destination=' +
                encodeURIComponent(window.location.href));
    }
};