AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-analytics-resources");

module("JIRA.DevStatus.Analytics", {
    linkSelector : 'a.devstatus-cta-link',
    dialogId : 'devstatus-cta-dialog',
    panelSelector : "#devstatus-container",

    issueType : "issue type",
    issueStatus : "issue status",
    title : "title def",

    setup : function () {
        this.sandbox = sinon.sandbox.create();
        this.server = this.sandbox.useFakeServer();

        var fixture = jQuery("#qunit-fixture");

        this.devStatusPanel = jQuery('<div id="devstatus-container">').appendTo(fixture);
        this.ctaHelptip = jQuery('<div class="cta-tooltip">').appendTo(fixture);
        this.ctaDialog = jQuery('<div id="devstatus-cta-dialog">').appendTo(fixture);
        this.adminDiv = jQuery('<div id="project-config-panel-dev-status">').appendTo(fixture);
        this.adminSummaryDiv = jQuery('<div id="project-config-webpanel-devstatus-admin-summary-panel">').appendTo(fixture);
    },

    teardown : function () {
        this.sandbox.restore();
        JIRA.unbind(JIRA.Events.NEW_CONTENT_ADDED);
//        jQuery(document).off("click", "a.devstatus-cta-link");
        jQuery(document).off("click", "#devstatus-cta-dialog .jira-dialog-content .target");
        jQuery(document).off("click", "#devstatus-cta-dialog .jira-dialog-content button.cancel");
        jQuery(document).off("click", ".cta-tooltip .cta-learn-more-link");
    },

    createCreateBranchButton : function (issueType, issueStatus, isAssignee) {
        jQuery('<a href="#devstatus.cta.createbranch" class="devstatus-cta-link" ' +
                ' data-issue-type="' + issueType + '"' +
                ' data-issue-status="' + issueStatus + '"' +
                ' data-is-assignee="' + isAssignee + '">').appendTo(this.devStatusPanel);
    },

    getCreateBranchButton : function () {
        return this.devStatusPanel.find("a.devstatus-cta-link");
    },

    createCreateBranchInstance : function (title) {
        var dialogContent = jQuery('<div class="jira-dialog-content">').appendTo(this.ctaDialog);
        var targets = jQuery('<ul class="targets">').appendTo(dialogContent);
        var li = jQuery('<li />').appendTo(targets);
        jQuery('<a class="target" />').appendTo(li).
            append(jQuery('<div class="title" title="' + title + '" />'));
    },

    createCreateBranchCancelButton : function () {
        var dialogContent = jQuery('<div class="jira-dialog-content">').appendTo(this.ctaDialog);
        var buttonContainer = jQuery('<div class="buttons-container">').appendTo(dialogContent);
        var buttons = jQuery('<div class="buttons"/>').appendTo(buttonContainer);
        jQuery('<button class="aui-button aui-button-link cancel">Cancel</button>').appendTo(buttons);
    },

    createCreateBranchHelptip : function() {
        jQuery('<a class="cta-learn-more-link"/>').appendTo(this.ctaHelptip);
    },

    getCreateBranchInstanceLink : function () {
        return this.ctaDialog.find("a.target");
    },

    getCreateBranchCancelButton : function () {
        return this.ctaDialog.find("button.cancel");
    },

    getCreateBranchHelptipLink : function() {
        return this.ctaHelptip.find(".cta-learn-more-link");
    },

    createAdminLinks : function () {
        jQuery('<a class="edit-permission-link"/>').appendTo(this.adminDiv);
        jQuery('<a class="learn-more-link"/>').appendTo(this.adminDiv);
    },

    createPermissionList : function () {
        jQuery('<ul class="permissions-list"/>').appendTo(this.adminDiv).
            append(jQuery('<li class="devstatus-admin-permission-item">permission 1</li>')).
            append(jQuery('<li class="devstatus-admin-permission-item">permission 2</li>'));
    },

    createAdminConnectButton : function () {
        var buttonDiv = jQuery('<div class="supported-app-connect-button">').appendTo(this.adminDiv);
        var buttons = jQuery('<div class="aui-buttons">').appendTo(buttonDiv);
        jQuery('<button id="project-config-applinks-connect">').appendTo(buttons);
        var listDiv = jQuery('<div id="project-config-applinks-connect-list">').appendTo(buttonDiv);
        var ul = jQuery('<ul"/>').appendTo(listDiv);
        var li = jQuery('<li"/>').appendTo(ul);
        jQuery('<a class="devstatus-admin-connect-button-option" data-key="key"/>').appendTo(li);
    },

    createAdminSummaryLinks : function () {
        var ul = jQuery('<ul class="project-config-list"/>').appendTo(this.adminSummaryDiv);
        var li = jQuery('<li class="permissions"/>').appendTo(ul);
        var span = jQuery('<span class="project-config-list-value"/>').appendTo(li);
        jQuery('<a class="edit-permission-link"/>').appendTo(span);
    },

    getEditPermissionLink : function () {
        return this.adminDiv.find(".edit-permission-link");
    },

    getConnectDropdownButton : function () {
        return this.adminDiv.find("#project-config-applinks-connect");
    },

    getConnectButtonInDropdown : function () {
        return this.adminDiv.find(".devstatus-admin-connect-button-option");
    },

    getEditPermissionLinkFromSummary : function () {
        return this.adminSummaryDiv.find(".edit-permission-link");
    },

    getAppvertisementLearnMoreLink : function () {
        return this.adminDiv.find(".learn-more-link");
    },

    _createCreateBranchButtonAndClick : function (isIssueNav, isAssignee) {
        if (isIssueNav) {
            // simulating issue nav, the button is created after page load, but before the NEW_CONTENT_ADDED trigger
            JIRA.DevStatus.CtaDialogAnalytics.initialize(this.panelSelector, this.linkSelector, this.dialogId);
            this.createCreateBranchButton(this.issueType, this.issueStatus, isAssignee);
            JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [this.devStatusPanel, JIRA.CONTENT_ADDED_REASON.dialogReady ]);
        } else {
            // simulating single view issue page, the button is created before page load, but no the NEW_CONTENT_ADDED trigger
            this.createCreateBranchButton(this.issueType, this.issueStatus, isAssignee);
            JIRA.DevStatus.CtaDialogAnalytics.initialize(this.panelSelector, this.linkSelector, this.dialogId);
        }
        this.getCreateBranchButton().click();
    },

    _assertEventProperty : function (event, propertyName, expectedValue) {
        equal(event.properties[propertyName], expectedValue, "Triggered event has the right '" + propertyName + "' attribute");
    },

    _assertEventProperties : function (event, expectedProperties) {
        var instance = this;
        _.each(expectedProperties, function (value, key) {
            instance._assertEventProperty(event, key, value);
        });
    },

    _assertCtaEvent : function (event, name, isAssignee, extraProperties) {
        equal(event.name, "devstatus.createbranch." + name + "." + (isAssignee ? "assignee" : "nonassignee"), "Triggered event has the right name");
        this._assertEventProperty(event, "issueType", this.issueType);
        this._assertEventProperty(event, "issueStatus", this.issueStatus);
        if (extraProperties) {
            this._assertEventProperties(event, extraProperties);
        }
    },

    _assertEvent : function (event, name, expectedProperties, extraMessage) {
        var msg = "Triggered event has the right name " + (extraMessage || "");
        equal(event.name, "devstatus." + name, msg);
        if (expectedProperties) {
            this._assertEventProperties(event, expectedProperties);
        }
    },

    _assertAdminEvent : function (event, name, expectedProperties) {
        this._assertEvent(event, "admin." + name, expectedProperties);
    },

    _assertLearnMoreEvent : function (event, name, expectedProperties) {
        this._assertEvent(event, "learnmore." + name, expectedProperties);
    },

    _assertCommitsEvent : function (event, name, expectedProperties) {
        this._assertEvent(event, "commits." + name, expectedProperties);
    },

    _assertLabsEvent : function (event, name, expectedProperties) {
        this._assertEvent(event, "labs." + name, expectedProperties);
    },

    _assertBranchesEvent: function (event, name, expectedProperties) {
        this._assertEvent(event, "branches." + name, expectedProperties, "for branches");
    },

    _assertBuildsEvent: function (event, name, expectedProperties) {
        this._assertEvent(event, "builds." + name, expectedProperties, "for builds");
    },

    _assertReviewsEvent: function (event, name, expectedProperties) {
        this._assertEvent(event, "reviews." + name, expectedProperties, "for reviews");
    },

    _assertPullRequestsEvent: function (event, name, expectedProperties) {
        this._assertEvent(event, "pullrequests." + name, expectedProperties, "for pull requests");
    },

    mockEventQueueAndRunTest : function(theTest) {
        var existingDarkFeatures = AJS.DarkFeatures;

        try {
            AJS.EventQueue = {
                push: sinon.spy()
            };

            AJS.DarkFeatures = {
                isEnabled : function(key) {
                    return false;
                }
            };

            // tests always have 0 parameters
            theTest.call(this);
        } finally {
            AJS.DarkFeatures = existingDarkFeatures;
        }
    },

    testCtaClickCreateBranchAnalytics : function(isIssueNav, isAssignee) {
        this.mockEventQueueAndRunTest(function() {
            this._createCreateBranchButtonAndClick(isIssueNav, isAssignee);

            equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

            var event = AJS.EventQueue.push.args[0][0];
            this._assertCtaEvent(event, "click", isAssignee);
        });
    },

    _createCreateBranchInstanceAndClick : function (title) {
        this.createCreateBranchInstance(title);

        this.getCreateBranchInstanceLink().click();
    },

    testCtaClickInstanceAnalytics : function(isIssueNav, isAssignee) {
        this.mockEventQueueAndRunTest(function() {
            this._createCreateBranchButtonAndClick(isIssueNav, isAssignee);
            this._createCreateBranchInstanceAndClick(this.title);

            equal(AJS.EventQueue.push.callCount, 2, "Triggered two events");

            var event = AJS.EventQueue.push.args[1][0];
            this._assertCtaEvent(event, "dialog.click", isAssignee, { title : this.title});
        });
    },

    _createCreateBranchCancelButtonAndClick : function () {
        this.createCreateBranchCancelButton();

        this.getCreateBranchCancelButton().click();
    },

    testCtaClickCancelAnalytics : function(isIssueNav, isAssignee) {
        this.mockEventQueueAndRunTest(function() {
            this._createCreateBranchButtonAndClick(isIssueNav, isAssignee);
            this._createCreateBranchCancelButtonAndClick();

            equal(AJS.EventQueue.push.callCount, 2, "Triggered two events");

            var event = AJS.EventQueue.push.args[1][0];
            this._assertCtaEvent(event, "dialog.cancel", isAssignee);
        });
    }

});

test("Clicking on create branch button triggers analytics event for assignee on single view issue page", function() {
    this.testCtaClickCreateBranchAnalytics(false, true);
});

test("Clicking on create branch button triggers analytics event for assignee on issue nav", function() {
    this.testCtaClickCreateBranchAnalytics(true, true);
});

test("Clicking on create branch button triggers analytics event for non-assignee on single view issue page", function() {
    this.testCtaClickCreateBranchAnalytics(false, false);
});
test("Clicking on create branch button triggers analytics event for non-assignee on issue nav", function() {
    this.testCtaClickCreateBranchAnalytics(true, false);
});

test("Clicking on create branch button triggers newcontext analytics event when instructed from URL", function() {
    this.mockEventQueueAndRunTest(function() {
        AJS.Meta.set("fusion-analytics-new-context-link", true);
        this._createCreateBranchButtonAndClick(true, true);

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertCtaEvent(event, "click.newcontext", true);
    });
});

test("Clicking on an instance in cta dialog for assignee on single view issue page", function() {
    this.testCtaClickInstanceAnalytics(false, true);
});

test("Clicking on an instance in cta dialog for assignee on issue nav", function() {
    this.testCtaClickInstanceAnalytics(true, true);
});

test("Clicking on an instance in cta dialog for non-assignee on single view issue page", function() {
    this.testCtaClickInstanceAnalytics(false, false);
});

test("Clicking on an instance in cta dialog for non-assignee on issue nav", function() {
    this.testCtaClickInstanceAnalytics(true, false);
});

test("Cancel in cta dialog for assignee on single view issue page", function() {
    this.testCtaClickCancelAnalytics(false, true);
});

test("Cancel in cta dialog for assignee on issue nav", function() {
    this.testCtaClickCancelAnalytics(true, true);
});

test("Cancel in cta dialog for non-assignee on single view issue page", function() {
    this.testCtaClickCancelAnalytics(false, false);
});

test("Cancel in cta dialog for non-assignee on issue nav", function() {
    this.testCtaClickCancelAnalytics(true, false);
});

test("Clicking on learn more link in the cta helptip inline dialog", function() {
    this.mockEventQueueAndRunTest(function() {
        this.createCreateBranchHelptip();
        JIRA.DevStatus.CtaDialogAnalytics.initialize();

        this.getCreateBranchHelptipLink().click();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertLearnMoreEvent(event, "click.ctahelptipbranching");
    });
});

test("Clicking on edit permission link on admin page without permissions", function() {
    this.mockEventQueueAndRunTest(function() {
        this.createAdminLinks();

        JIRA.DevStatus.AdminAnalytics.initialize();

        this.getEditPermissionLink().click();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertAdminEvent(event, "editpermissionlink.config.nopermissions");
    });
});

test("Clicking on edit permission link on admin page with permissions", function() {
    this.mockEventQueueAndRunTest(function() {
        this.createAdminLinks();
        this.createPermissionList();

        JIRA.DevStatus.AdminAnalytics.initialize();

        this.getEditPermissionLink().click();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertAdminEvent(event, "editpermissionlink.config.withpermissions");
    });
});

test("Clicking on appvertisement link more link on admin page", function() {
    this.mockEventQueueAndRunTest(function() {
        this.createAdminLinks();

        JIRA.DevStatus.AdminAnalytics.initialize();

        this.getAppvertisementLearnMoreLink().click();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertLearnMoreEvent(event, "click.adminappvertisementlink");
    });
});

test("Sending a summary event actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {

        JIRA.DevStatus.SummaryAnalytics.fireSummaryShownEvent(false, "bug", "in-review", {pokemon: "gotta catch", all: true});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertEvent(event, "summary.shown.nonassignee",
                { issueType: "bug", issueStatus : "in-review", pokemon: "gotta catch", all: true});
    });
});

test("Sending a summary event with assignee", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.SummaryAnalytics.fireSummaryShownEvent(true, "bug", "in-review", {pokemon: "gotta catch", all: false});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertEvent(event, "summary.shown.assignee",
                { issueType: "bug", issueStatus : "in-review", pokemon: "gotta catch", all: false});
    });
});

test("Sending a summary clicked for new context event", function() {
    this.mockEventQueueAndRunTest(function() {
        AJS.Meta.set("fusion-analytics-new-context-link", true);
        JIRA.DevStatus.SummaryAnalytics.fireSummaryClickedEvent("deployments", {pokemon: "pikachu"});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertEvent(event, "deployments.summary.clicked.newcontext", {pokemon: "pikachu"});
        equal(AJS.Meta.get("fusion-analytics-new-context-link"), undefined, "AJS.Meta is reset after firing analytics event");
    });
});

test("Sending a summary clicked event actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.CommitsAnalytics.fireSummaryClickedEvent({commit: true});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertCommitsEvent(event, "summary.clicked", {commit: true});
    });
});

test("Sending a bitbucket repo clicked event actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.CommitsAnalytics.fireDetailRepoClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertCommitsEvent(event, "detail.bitbucket.repo.clicked");
    });
});

test("Sending a bitbucket commit clicked event actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.CommitsAnalytics.fireDetailCommitClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertCommitsEvent(event, "detail.bitbucket.commit.clicked");
    });
});

test("Sending a panel icon clicked in agile event actually sends that event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.Analytics.fireAgileDevStatusLinkClicked();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertEvent(event, "panel.agile.icon.clicked");
    });
});

test("Clicking on branch summary link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireSummaryClickedEvent({branch: false});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "summary.clicked", {branch: false});
    });
});

test("In branch detail dialog, clicking on repository link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailRepoClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.repo.clicked");
    });
});

test("In branch detail dialog, clicking on branch link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailBranchClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.branch.clicked");
    });
});

test("In branch detail dialog, clicking on pull request lozenge actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailPullRequestLozengeClick('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.pullrequest.lozenge.clicked");
    });
});

test("In branch detail dialog, clicking on create pull request when user is assigned actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailCreatePullRequestClicked('bitbucket', true);

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.pullrequest.create.assignee.clicked");
    });
});

test("In branch detail dialog, clicking on create pull request when user is NOT assigned, but is assignable actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailCreatePullRequestClicked('bitbucket', false, true);

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.pullrequest.create.nonassignee.assignable.clicked");
    });
});

test("In branch detail dialog, clicking on create pull request when user is NOT assigned and is NOT assignable actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailCreatePullRequestClicked('bitbucket', false, false);

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.pullrequest.create.nonassignee.nonassignable.clicked");
    });
});

test("In branch detail dialog, clicking on product tab actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BranchesAnalytics.fireDetailTabClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBranchesEvent(event, "detail.bitbucket.tab.clicked");
    });
});

test("Clicking on review summary link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.ReviewsAnalytics.fireSummaryClickedEvent({review: true});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertReviewsEvent(event, "summary.clicked", {review: true});
    });
});

test("In review detail dialog, clicking on a review actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.ReviewsAnalytics.fireDetailReviewClicked();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertReviewsEvent(event, "detail.review.clicked");
    });
});


test("Clicking on build summary link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BuildsAnalytics.fireSummaryClickedEvent({build: true});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBuildsEvent(event, "summary.clicked", {build: true});
    });
});

test("In build detail dialog, clicking on project actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BuildsAnalytics.fireDetailProjectClicked();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBuildsEvent(event, "detail.project.clicked");
    });
});

test("In build detail dialog, clicking on plan actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BuildsAnalytics.fireDetailPlanClicked();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBuildsEvent(event, "detail.plan.clicked");
    });
});

test("In build detail dialog, clicking on build actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.BuildsAnalytics.fireDetailBuildClicked();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertBuildsEvent(event, "detail.build.clicked");
    });
});

test("Clicking on pull request summary link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.PullRequestsAnalytics.fireSummaryClickedEvent({pullrequest: true});

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertPullRequestsEvent(event, "summary.clicked", {pullrequest: true});
    });
});

test("In pull request detail dialog, clicking on pull request link actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.PullRequestsAnalytics.fireDetailPullRequestClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertPullRequestsEvent(event, "detail.bitbucket.pullrequest.clicked");
    });
});

test("In pull request detail dialog, clicking on product tab actually sends an event", function() {
    this.mockEventQueueAndRunTest(function() {
        JIRA.DevStatus.PullRequestsAnalytics.fireDetailTabClicked('bitbucket');

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertPullRequestsEvent(event, "detail.bitbucket.tab.clicked");
    });
});

test("Clicking on connect dropdown button on admin page", function() {
    this.mockEventQueueAndRunTest(function() {
        this.createAdminSummaryLinks();
        this.createAdminConnectButton();

        JIRA.DevStatus.AdminAnalytics.initialize();

        this.getConnectDropdownButton().click();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertAdminEvent(event, "connect");

        // now click on the button in the drop down
        this.getConnectButtonInDropdown().click();

        equal(AJS.EventQueue.push.callCount, 2, "Triggered two events");

        event = AJS.EventQueue.push.args[1][0];
        this._assertAdminEvent(event, "connect.key");
    });
});

test("Clicking on edit permission link on admin summary page", function() {
    this.mockEventQueueAndRunTest(function() {
        this.createAdminSummaryLinks();

        JIRA.DevStatus.AdminSummaryAnalytics.initialize();

        this.getEditPermissionLinkFromSummary().click();

        equal(AJS.EventQueue.push.callCount, 1, "Triggered one event");

        var event = AJS.EventQueue.push.args[0][0];
        this._assertAdminEvent(event, "editpermissionlink.summary.nopermissions");
    });
});

test("Turning off analytics via dark features", function() {
    this.mockEventQueueAndRunTest(function() {
        AJS.DarkFeatures.isEnabled = function (key) {
            return (key === "jira.plugin.devstatus.analytics.disabled"); // disable analytics
        };
        this.createAdminSummaryLinks();

        JIRA.DevStatus.AdminSummaryAnalytics.initialize();

        this.getEditPermissionLinkFromSummary().click();

        equal(AJS.EventQueue.push.callCount, 0, "Triggered no events");
    });
});
