(function ($, JIRA, contextPath) {
    $(function() {
        JIRA.DevStatus.AdminAnalytics.initialize();

        var $refreshLink = $("#refresh-capabilities-link"),
            $refreshIcon = $refreshLink.find("#refresh-capabilities-icon"),
            waitforRemoteFetch = 15000;

        $refreshLink.click(function (e) {
            e.preventDefault();
            if (!$refreshIcon.hasClass("aui-icon-wait")) {
                $refreshIcon.toggleClass("aui-iconfont-build aui-icon-wait");
                $.ajax({
                    url: contextPath + "/rest/capabilities-consumer/1.0/admin/refreshcache",
                    type: "POST",
                    success: function () {
                        setTimeout(function(){
                            JIRA.DevStatus.Navigate.reload();
                        },waitforRemoteFetch);
                    },
                    error: function () {
                        $refreshIcon.removeClass("aui-icon-wait").addClass("aui-iconfont-build");
                    }
                });
            }
        });
    });
})(AJS.$, JIRA, AJS.contextPath());
