/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.processor;

import com.atlassian.plugin.spring.scanner.processor.IndexWritingAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.springframework.stereotype.Component", "javax.inject.Named", "com.atlassian.plugin.spring.scanner.annotation.component.*"})
public class ComponentAnnotationProcessor
extends IndexWritingAnnotationProcessor {
    public static final String SPRING_COMPONENT_ANNOTATION = "org.springframework.stereotype.Component";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.doProcess(annotations, roundEnv, "component");
        return false;
    }

    @Override
    public IndexWritingAnnotationProcessor.TypeAndAnnotation getTypeAndAnnotation(Element element, TypeElement anno) {
        String message;
        VariableElement variableElement;
        Class<?> componentAnnoClass;
        TypeElement typeElement = null;
        Annotation annotation = null;
        IndexWritingAnnotationProcessor.TypeAndAnnotation typeAndAnnotation = null;
        try {
            componentAnnoClass = Class.forName(anno.getQualifiedName().toString());
        }
        catch (ClassNotFoundException e) {
            return typeAndAnnotation;
        }
        if (element instanceof TypeElement) {
            typeElement = (TypeElement)element;
            annotation = (Annotation)typeElement.getAnnotation(componentAnnoClass);
            typeAndAnnotation = new IndexWritingAnnotationProcessor.TypeAndAnnotation(this, typeElement, annotation);
        } else if (element instanceof VariableElement && ElementKind.PARAMETER.equals((Object)(variableElement = (VariableElement)element).getKind()) && ElementKind.CONSTRUCTOR.equals((Object)variableElement.getEnclosingElement().getKind())) {
            typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            annotation = (Annotation)variableElement.getAnnotation(componentAnnoClass);
            typeAndAnnotation = new IndexWritingAnnotationProcessor.TypeAndAnnotation(this, typeElement, annotation);
        }
        if (null != typeElement && !ElementKind.CLASS.equals((Object)typeElement.getKind())) {
            message = "Annotation processor found a type [" + typeAndAnnotation.getTypeElement().getQualifiedName().toString() + "] annotated as a component, but the type is not a concrete class. NOT adding to index file!!";
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, message);
            typeAndAnnotation = null;
        }
        if (null != typeElement && typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            message = "Annotation processor found a type [" + typeAndAnnotation.getTypeElement().getQualifiedName().toString() + "] annotated as a component, but the type is abstract. NOT adding to index file!!";
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, message);
            typeAndAnnotation = null;
        }
        return typeAndAnnotation;
    }
}

