/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.extension.ExportedSeviceManager;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.osgi.service.exporter.support.AutoExport;

public class ServiceExporterBeanPostProcessor
implements DestructionAwareBeanPostProcessor {
    public static final String OSGI_SERVICE_SUFFIX = "_osgiService";
    private static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private final ExportedSeviceManager serviceManager;
    private final BundleContext bundleContext;
    private ConfigurableListableBeanFactory beanFactory;

    public ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        this.bundleContext = bundleContext;
        this.beanFactory = beanFactory;
        this.serviceManager = new ExportedSeviceManager();
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.isPublicComponent(bean)) {
            Object serviceBean;
            String serviceName = this.getServiceName(beanName);
            this.serviceManager.unregisterService(this.bundleContext, bean);
            if (this.beanFactory.containsBean(serviceName) && null != (serviceBean = this.beanFactory.getBean(serviceName))) {
                this.beanFactory.destroyBean(serviceName, serviceBean);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class[] interfaces = new Class[]{};
        if (this.isPublicComponent(bean)) {
            String serviceName = this.getServiceName(beanName);
            AutoExport autoExport = AutoExport.DISABLED;
            if (bean.getClass().isAnnotationPresent(ExportAsService.class)) {
                interfaces = bean.getClass().getAnnotation(ExportAsService.class).value();
            } else if (bean.getClass().isAnnotationPresent(ExportAsDevService.class)) {
                interfaces = bean.getClass().getAnnotation(ExportAsDevService.class).value();
            }
            if (interfaces.length < 1 && (interfaces = bean.getClass().getInterfaces()).length < 1) {
                interfaces = new Class[]{bean.getClass()};
            }
            try {
                ServiceRegistration reg = this.serviceManager.registerService(this.bundleContext, bean, beanName, new Hashtable<String, Object>(), autoExport, interfaces);
                this.beanFactory.initializeBean((Object)reg, serviceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bean;
    }

    private boolean isPublicComponent(Object bean) {
        return bean.getClass().isAnnotationPresent(ExportAsService.class) || bean.getClass().isAnnotationPresent(ExportAsDevService.class) && isDevMode;
    }

    private String getServiceName(String beanName) {
        return beanName + OSGI_SERVICE_SUFFIX;
    }
}

