/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;

public class ComponentImportBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final BundleContext bundleContext;
    private boolean autoImports;

    public ComponentImportBeanFactoryPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.autoImports = false;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        Bundle bundle = this.bundleContext.getBundle();
        List<String> classNames = AnnotationIndexReader.readAllIndexFilesForProduct("META-INF/plugin-components/imports", bundle);
        for (String className : classNames) {
            String[] typeAndName = StringUtils.split((String)className, (String)"#");
            String beanType = typeAndName[0];
            String beanName = typeAndName.length > 1 ? typeAndName[1] : "";
            try {
                Class<?> beanClass = beanFactory.getBeanClassLoader().loadClass(beanType);
                this.registerComponentImportBean(registry, beanClass, beanName);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    private void registerComponentImportBean(BeanDefinitionRegistry registry, Class beanClass, String beanName) {
        String serviceBeanName = beanName;
        if ("".equals(serviceBeanName)) {
            serviceBeanName = StringUtils.uncapitalize((String)beanClass.getSimpleName());
        }
        this.registerBeanDefinition(registry, serviceBeanName, "(objectClass=" + beanClass.getName() + ")", beanClass);
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, String filter, Class interfaces) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(OsgiServiceProxyFactoryBean.class);
        builder.setAutowireMode(3);
        builder.setRole(2);
        if (StringUtils.isNotBlank((String)filter)) {
            builder.addPropertyValue("filter", (Object)filter);
        }
        long timeout = 1000L;
        builder.addPropertyValue("interfaces", (Object)new Class[]{interfaces});
        builder.addPropertyValue("beanClassLoader", (Object)OsgiPlugin.class.getClassLoader());
        AbstractBeanDefinition newDefinition = builder.getBeanDefinition();
        registry.registerBeanDefinition(beanName, (BeanDefinition)newDefinition);
    }

    public void setAutoImports(boolean autoImports) {
        this.autoImports = autoImports;
    }
}

