/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.atlassian.plugin.spring.scanner.util.BeanDefinitionChecker;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

public class ClassIndexBeanDefinitionScanner {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanDefinitionRegistry registry;

    public ClassIndexBeanDefinitionScanner(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    protected Set<BeanDefinitionHolder> doScan() {
        LinkedHashSet<BeanDefinitionHolder> beanDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        Map<String, BeanDefinition> namesAndDefinitions = this.findCandidateComponents();
        for (Map.Entry<String, BeanDefinition> nameAndDefinition : namesAndDefinitions.entrySet()) {
            if (!BeanDefinitionChecker.needToRegister(nameAndDefinition.getKey(), nameAndDefinition.getValue(), this.registry)) continue;
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(nameAndDefinition.getValue(), nameAndDefinition.getKey());
            beanDefinitions.add(definitionHolder);
            this.registerBeanDefinition(definitionHolder, this.registry);
        }
        return beanDefinitions;
    }

    public Map<String, BeanDefinition> findCandidateComponents() {
        HashMap<String, BeanDefinition> candidates = new HashMap<String, BeanDefinition>();
        List<String> beanTypeAndNames = AnnotationIndexReader.readAllIndexFilesForProduct("META-INF/plugin-components/component", Thread.currentThread().getContextClassLoader());
        for (String beanTypeAndName : beanTypeAndNames) {
            String[] typeAndName = StringUtils.split((String)beanTypeAndName, (String)"#");
            String beanClassname = typeAndName[0];
            String beanName = "";
            if (typeAndName.length > 1) {
                beanName = typeAndName[1];
            }
            if (StringUtils.isBlank((String)beanName)) {
                beanName = Introspector.decapitalize(ClassUtils.getShortName((String)beanClassname));
            }
            candidates.put(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition((String)beanClassname).getBeanDefinition());
        }
        return candidates;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
    }
}

