/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.web.admin;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.devstatus.analytics.AnalyticsHelper;
import com.atlassian.jira.plugin.devstatus.analytics.DevStatusAdminPageShownEvent;
import com.atlassian.jira.plugin.devstatus.api.DevStatusPermissionService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationService;
import com.atlassian.jira.plugin.devstatus.api.PermissionHolders;
import com.atlassian.jira.plugin.devstatus.api.SupportedApplication;
import com.atlassian.jira.plugin.devstatus.impl.DvcsType;
import com.atlassian.jira.plugin.devstatus.impl.SupportedApplicationPredicates;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsLinkServiceAccessor;
import com.atlassian.jira.plugin.devstatus.web.admin.AbstractProjectAdminAction;
import com.atlassian.jira.plugin.devstatus.web.admin.ConnectableApplicationType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ConfigureDevStatus
extends AbstractProjectAdminAction {
    static final String CONNECTABLE_APPLICATION_TYPES = "connectableAppTypes";
    static final String DISPLAY_PANEL_ERROR = "errors";
    static final String HAS_INCAPABLE_APPLICATION = "hasIncapableApplication";
    static final String HAS_2LO_CONFIG_APPLICATION = "hasTwoLOConfigApplication";
    static final String IS_ADMIN = "isAdmin";
    static final String PERMISSION_HOLDERS = "permissionHolders";
    static final String PERMISSION_SCHEME_ID = "permissionSchemeId";
    static final String PROJECT_KEY = "projectKey";
    static final String PROJECT_NAME = "projectName";
    static final String SUPPORTED_APPLICATIONS = "supportedApplications";
    static final String ANALYTICS_TRACKING_SOURCE = "devtools";
    static final String BASE_URL = "baseUrl";
    private final AnalyticsHelper analyticsHelper;
    private final DevStatusPermissionService devStatusPermissionService;
    private final DevStatusSupportedApplicationService devStatusSupportedApplicationService;
    private final DvcsLinkServiceAccessor dvcsLinkServiceAccessor;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final ProjectService projectService;
    private final VelocityRequestContextFactory contextFactory;
    private final PageBuilderService pageBuilderService;
    private PermissionHolders permissionHolders;

    public ConfigureDevStatus(AnalyticsHelper analyticsHelper, DevStatusPermissionService devStatusPermissionService, DevStatusSupportedApplicationService devStatusSupportedApplicationService, DvcsLinkServiceAccessor dvcsLinkServiceAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport PermissionSchemeManager permissionSchemeManager, @ComponentImport ProjectService projectService, @ComponentImport VelocityRequestContextFactory contextFactory, @ComponentImport PageBuilderService pageBuilderService) {
        this.analyticsHelper = analyticsHelper;
        this.contextFactory = contextFactory;
        this.devStatusPermissionService = devStatusPermissionService;
        this.devStatusSupportedApplicationService = devStatusSupportedApplicationService;
        this.dvcsLinkServiceAccessor = dvcsLinkServiceAccessor;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.projectService = projectService;
        this.pageBuilderService = pageBuilderService;
    }

    private void init() {
        this.initRequest();
        this.requireResources();
        this.setBackToProjectPath();
    }

    protected String doExecute() throws Exception {
        this.init();
        ApplicationUser user = this.getLoggedInApplicationUser();
        if (user == null) {
            HttpServletRequest request = ExecutingHttpRequest.get();
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
        String projectKey = this.getProjectKey();
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            return this.missingProjectError();
        }
        ProjectService.GetProjectResult result = this.projectService.getProjectByKeyForAction(user, projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!result.isValid()) {
            return this.errorsFrom((ServiceResult)result);
        }
        Project project = result.getProject();
        if (project == null) {
            return this.missingProjectError();
        }
        ServiceOutcome<PermissionHolders> entities = this.devStatusPermissionService.getPermissionHolders(project);
        if (!entities.isValid()) {
            return this.errorsFrom((ServiceResult)entities);
        }
        this.permissionHolders = (PermissionHolders)entities.getReturnedValue();
        return "success";
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getDataMap() {
        List<SupportedApplication> supportedApps = this.getSupportedApplications();
        boolean hasIncapableApp = Iterables.any(supportedApps, (Predicate)SupportedApplicationPredicates.HAS_MISSING_CAPABILITIES_PREDICATE);
        boolean hasTwoLOConfigApp = Iterables.any(supportedApps, (Predicate)SupportedApplicationPredicates.HAS_NEED_TWO_LO_PREDICATE);
        this.sendAnalytics(supportedApps.isEmpty());
        return EasyMap.build((Object[])new Object[]{CONNECTABLE_APPLICATION_TYPES, this.getConnectableApplicationTypes(), IS_ADMIN, this.isAdministrator(), HAS_INCAPABLE_APPLICATION, hasIncapableApp, HAS_2LO_CONFIG_APPLICATION, hasTwoLOConfigApp, PERMISSION_HOLDERS, this.permissionHolders, PERMISSION_SCHEME_ID, this.getPermissionSchemeId(), PROJECT_KEY, this.getProjectKeyOrEmpty(), PROJECT_NAME, this.getProjectNameOrEmpty(), SUPPORTED_APPLICATIONS, supportedApps, BASE_URL, this.contextFactory.getJiraVelocityRequestContext().getBaseUrl()});
    }

    @ActionViewDataMappings(value={"error"})
    public Map<String, Object> getDataMapForError() {
        return EasyMap.build((Object)DISPLAY_PANEL_ERROR, (Object)this.getErrorMessages(), (Object)PROJECT_KEY, (Object)this.getProjectKeyOrEmpty());
    }

    private String missingProjectError() {
        this.setErrorMessages(Collections.singletonList(this.getText("admin.errors.project.not.found.for.key", this.getProjectKeyOrEmpty())));
        return "error";
    }

    private String errorsFrom(ServiceResult result) {
        this.setErrorMessages(result.getErrorCollection().getErrorMessages());
        this.setErrors(result.getErrorCollection().getErrors());
        return "error";
    }

    private String getProjectKeyOrEmpty() {
        return StringUtils.defaultString((String)this.getProjectKey());
    }

    private String getProjectNameOrEmpty() {
        Project project = this.getProject();
        return StringUtils.defaultString((String)(project == null ? null : project.getName()));
    }

    private Long getPermissionSchemeId() {
        Scheme scheme;
        Project project = this.getProject();
        if (project != null && (scheme = this.permissionSchemeManager.getSchemeFor(project)) != null) {
            return scheme.getId();
        }
        return null;
    }

    private boolean isAdministrator() {
        return this.permissionManager.hasPermission(0, this.getLoggedInApplicationUser());
    }

    private List<SupportedApplication> getSupportedApplications() {
        ServiceOutcome<List<SupportedApplication>> outcome = this.devStatusSupportedApplicationService.getSupportedApplications();
        return outcome.isValid() ? (List)outcome.getReturnedValue() : ImmutableList.of();
    }

    private Map getConnectableApplicationTypes() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        String contextPath = request.getContextPath();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"bamboo", (Object)new ConnectableApplicationType(this.getCreateAppLinkUrl(contextPath), this.getText("admin.project.devstatus.admin.connect.bamboo.title")));
        if (this.dvcsLinkServiceAccessor.getService() != null) {
            mapBuilder.put((Object)DvcsType.BITBUCKET.type(), (Object)new ConnectableApplicationType(this.getDvcsLinkUrl(contextPath, DvcsType.BITBUCKET), this.getText("admin.project.devstatus.admin.connect.bitbucket.title")));
            mapBuilder.put((Object)DvcsType.GITHUB.type(), (Object)new ConnectableApplicationType(this.getDvcsLinkUrl(contextPath, DvcsType.GITHUB), this.getText("admin.project.devstatus.admin.connect.github.title")));
            mapBuilder.put((Object)DvcsType.GITHUB_ENTERPRISE.type(), (Object)new ConnectableApplicationType(this.getDvcsLinkUrl(contextPath, DvcsType.GITHUB_ENTERPRISE), this.getText("admin.project.devstatus.admin.connect.github.enterprise.title")));
        }
        return mapBuilder.put((Object)"fecru", (Object)new ConnectableApplicationType(this.getCreateAppLinkUrl(contextPath), this.getText("admin.project.devstatus.admin.connect.fecru.title"))).put((Object)"stash", (Object)new ConnectableApplicationType(this.getCreateAppLinkUrl(contextPath), this.getText("admin.project.devstatus.admin.connect.stash.title"))).build();
    }

    private String getRequestUrl(HttpServletRequest request) {
        return "/secure/ConfigureDevStatus.jspa?" + request.getQueryString();
    }

    private String getCreateAppLinkUrl(String contextPath) {
        return contextPath + "/plugins/servlet/applinks/listApplicationLinks";
    }

    private String getDvcsLinkUrl(String contextPath, DvcsType dvcsType) {
        return contextPath + "/secure/admin/ConfigureDvcsOrganizations!default.jspa?source=" + ANALYTICS_TRACKING_SOURCE + "&selectHost=" + dvcsType.type() + "#expand";
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireContext("jira.plugin.dev.status.project.admin");
    }

    private void setBackToProjectPath() {
        VelocityRequestContext requestContext = this.contextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        session.setAttribute("atl.jira.admin.current.project", (Object)this.getProjectKey());
        session.setAttribute("atl.jira.admin.current.project.return.url", (Object)this.getRequestUrl(ExecutingHttpRequest.get()));
    }

    private void sendAnalytics(boolean showAppvertisement) {
        this.analyticsHelper.publishEvent(new DevStatusAdminPageShownEvent(showAppvertisement));
    }
}

