/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.web;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.devstatus.analytics.AnalyticsHelper;
import com.atlassian.jira.plugin.devstatus.analytics.DevStatusCreateBranchShownEvent;
import com.atlassian.jira.plugin.devstatus.api.CallToAction;
import com.atlassian.jira.plugin.devstatus.api.DevStatusCtaService;
import com.atlassian.jira.plugin.devstatus.labs.LabsOptIn;
import com.atlassian.jira.plugin.devstatus.labs.PhaseTwoFeatureFlag;
import com.atlassian.jira.plugin.devstatus.summary.cache.DevSummary;
import com.atlassian.jira.plugin.devstatus.summary.cache.DevSummaryCache;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueContextProvider
implements CacheableContextProvider {
    static final String CALL_TO_ACTIONS = "callToActions";
    static final String CONTEXT_KEY_ISSUE = "issue";
    static final String CONTEXT_KEY_USER = "user";
    static final String DEV_STATUS_PANEL = "devStatusPanels";
    static final String DEV_STATUS_PANEL_LOCATION = "atl.jira.view.issue.devstatus.panels";
    static final String IS_ASSIGNEE = "isAssignee";
    static final String IS_ASSIGNABLE = "isAssignable";
    static final String LABS_JSON = "labsOptInJson";
    static final String SHOW_CONTACT_ADMIN_FORM = "showContactAdminForm";
    static final String DEV_SUMMARY_JSON_BLOB = "devSummaryJson";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AnalyticsHelper analyticsHelper;
    private final ApplicationProperties applicationProperties;
    private final DevStatusCtaService devStatusCtaService;
    private final LabsOptIn labsOptIn;
    private final PermissionManager permissionManager;
    private final PhaseTwoFeatureFlag phaseTwoFeatureFlag;
    private final WebInterfaceManager webInterfaceManager;
    private final DevSummaryCache devSummaryCache;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public IssueContextProvider(AnalyticsHelper analyticsHelper, @ComponentImport ApplicationProperties applicationProperties, DevStatusCtaService devStatusCtaService, LabsOptIn labsOptIn, @ComponentImport PermissionManager permissionManager, PhaseTwoFeatureFlag phaseTwoFeatureFlag, @ComponentImport WebInterfaceManager webInterfaceManager, DevSummaryCache devSummaryCache) {
        this.analyticsHelper = analyticsHelper;
        this.applicationProperties = applicationProperties;
        this.devStatusCtaService = devStatusCtaService;
        this.labsOptIn = labsOptIn;
        this.permissionManager = permissionManager;
        this.phaseTwoFeatureFlag = phaseTwoFeatureFlag;
        this.webInterfaceManager = webInterfaceManager;
        this.devSummaryCache = devSummaryCache;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = this.getIssue(context);
        User user = this.getUser(context);
        return Long.toString(issue.getId()) + ":" + (user != null ? user.getName() : "");
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Optional<String> summaryDataJson;
        context = ImmutableMap.builder().putAll(Maps.filterValues(context, (Predicate)Predicates.notNull())).put((Object)IS_ASSIGNEE, (Object)this.isAssignee((Map<String, Object>)context)).put((Object)IS_ASSIGNABLE, (Object)this.isAssignable((Map<String, Object>)context)).build();
        List<CallToAction> callToActions = this.getCallToActions((Map<String, Object>)context);
        List<DevStatusPanel> devStatusPanels = this.getDevStatusPanels((Map<String, Object>)context);
        if (!callToActions.isEmpty() || !devStatusPanels.isEmpty()) {
            this.sendAnalytics((Map<String, Object>)context);
        }
        boolean showContactAdminForm = this.applicationProperties.getOption("jira.show.contact.administrators.form");
        ImmutableMap.Builder templateContext = ImmutableMap.builder().putAll((Map)context).put((Object)CALL_TO_ACTIONS, callToActions).put((Object)DEV_STATUS_PANEL, devStatusPanels).put((Object)LABS_JSON, (Object)this.toJSON(this.labsOptIn.asJsonBean())).put((Object)SHOW_CONTACT_ADMIN_FORM, (Object)showContactAdminForm);
        if (this.phaseTwoFeatureFlag.isPhaseTwoEnabled() && (summaryDataJson = this.getSummaryDataJson((Map<String, Object>)context)).isPresent()) {
            templateContext.put((Object)DEV_SUMMARY_JSON_BLOB, summaryDataJson.get());
        }
        return templateContext.build();
    }

    protected List<CallToAction> getCallToActions(Map<String, Object> context) {
        User user;
        Issue issue = this.getIssue(context);
        ServiceOutcome<List<CallToAction>> callToActions = this.devStatusCtaService.getCallToActions(issue, ApplicationUsers.from((User)(user = this.getUser(context))));
        if (!callToActions.isValid()) {
            Collection errorMessages = callToActions.getErrorCollection().getErrorMessages();
            this.log.error("Error while retrieving the call-to-actions: {}", (Object)StringUtils.join((Iterable)errorMessages, (String)", "));
            return ImmutableList.of();
        }
        return (List)callToActions.getReturnedValue();
    }

    protected List<DevStatusPanel> getDevStatusPanels(final Map<String, Object> context) {
        List panelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(DEV_STATUS_PANEL_LOCATION, context);
        return Lists.transform((List)panelDescriptors, (Function)new Function<WebPanelModuleDescriptor, DevStatusPanel>(){

            public DevStatusPanel apply(WebPanelModuleDescriptor panelDescriptor) {
                return new DevStatusPanel(panelDescriptor, context);
            }
        });
    }

    private Issue getIssue(Map<String, Object> context) {
        return (Issue)context.get(CONTEXT_KEY_ISSUE);
    }

    private User getUser(Map<String, Object> context) {
        return (User)context.get(CONTEXT_KEY_USER);
    }

    private boolean isAssignee(Map<String, Object> context) {
        Issue issue = this.getIssue(context);
        User user = this.getUser(context);
        return user != null && user.equals((Object)issue.getAssignee());
    }

    private boolean isAssignable(Map<String, Object> context) {
        Issue issue = this.getIssue(context);
        User user = this.getUser(context);
        return user != null && this.permissionManager.hasPermission(17, issue, user);
    }

    private void sendAnalytics(Map<String, Object> context) {
        Issue issue = this.getIssue(context);
        String issueType = issue.getIssueTypeObject().getName();
        String issueStatus = issue.getStatusObject().getName();
        this.analyticsHelper.publishEvent(new DevStatusCreateBranchShownEvent(this.isAssignee(context), issueType, issueStatus));
    }

    @Nonnull
    private Optional<String> getSummaryDataJson(Map<String, Object> context) {
        Issue issue = this.getIssue(context);
        DevSummary cachedSummary = this.devSummaryCache.getDevSummary(issue.getId(), true);
        return Optional.fromNullable((Object)this.toJSON(cachedSummary));
    }

    @Nullable
    private String toJSON(@Nullable Object object) {
        if (object != null) {
            try {
                return this.objectMapper.writeValueAsString(object);
            }
            catch (IOException e) {
                this.log.error("Error serialising to JSON: " + object, (Throwable)e);
            }
        }
        return null;
    }

    public static class DevStatusPanel {
        private final WebPanelModuleDescriptor panelDescriptor;
        private final Map<String, Object> context;

        private DevStatusPanel(WebPanelModuleDescriptor panelDescriptor, Map<String, Object> context) {
            this.panelDescriptor = panelDescriptor;
            this.context = context;
        }

        public String getHtml() {
            return ((WebPanel)this.panelDescriptor.getModule()).getHtml((Map)Maps.newHashMap(this.context));
        }
    }
}

