/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.web;

import com.atlassian.guava.base.Strings;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.devstatus.web.CallToActionLinkFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.navlink.consumer.menu.services.RemoteNavigationLinkService;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CTACreateReviewLinkFactory
extends CallToActionLinkFactory {
    private static final int MAX_DESCRIPTION_LENGTH = 1000;
    private final IssueManager issueManager;

    public CTACreateReviewLinkFactory(@ComponentImport RemoteNavigationLinkService remoteNavigationLinkService, I18nHelper i18nHelper, @ComponentImport IssueManager issueManager) {
        super(remoteNavigationLinkService, i18nHelper);
        this.issueManager = issueManager;
    }

    @Override
    protected String generateQueryString(Issue issue) {
        Set issueKeys = this.issueManager.getAllIssueKeys(issue.getId());
        UrlBuilder urlBuilder = new UrlBuilder(true);
        urlBuilder.addParameter("issueKey", issue.getKey());
        for (String oldIssueKey : Sets.difference((Set)issueKeys, Collections.singleton(issue.getKey()))) {
            urlBuilder.addParameter("issueKey", oldIssueKey);
        }
        urlBuilder.addParameter("issueSummary", issue.getSummary());
        urlBuilder.addParameter("issueDescription", StringUtils.abbreviate((String)Strings.nullToEmpty(issue.getDescription()), (int)1000));
        return urlBuilder.toString().substring(1);
    }
}

