/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fugue.Option;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.objects.ReviewsObject;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.AggregatorHelper;
import com.atlassian.jira.plugin.devstatus.summary.beans.OverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.plugin.devstatus.summary.util.AggregatorUtils;
import com.atlassian.jira.rest.Dates;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import org.codehaus.jackson.annotate.JsonProperty;

@Named
public class ReviewAggregator
implements Aggregator,
AggregatorHelper.JsonAggregator<ReviewsObject> {
    private static final List<ReviewsObject.ReviewState> VISIBLE_STATES = ImmutableList.of((Object)((Object)ReviewsObject.ReviewState.REVIEW), (Object)((Object)ReviewsObject.ReviewState.APPROVAL), (Object)((Object)ReviewsObject.ReviewState.SUMMARIZE), (Object)((Object)ReviewsObject.ReviewState.REJECTED), (Object)((Object)ReviewsObject.ReviewState.CLOSED));
    private static final Set<ReviewsObject.ReviewState> COMPLETED_STATES = ImmutableSet.of((Object)((Object)ReviewsObject.ReviewState.CLOSED), (Object)((Object)ReviewsObject.ReviewState.REJECTED));
    private final Predicate<ReviewsObject> IN_VISIBLE_STATE = Predicates.and((Predicate)Predicates.notNull(), (Predicate)Predicates.compose((Predicate)Predicates.in(VISIBLE_STATES), ReviewsObject.TO_STATE));

    @Override
    public String getType() {
        return ReviewsObject.ID.getId();
    }

    @Override
    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData, long issueId) {
        return AggregatorHelper.create(this).aggregate(summaryData);
    }

    public ReviewsOverallBean aggregateDataObjects(Collection<ReviewsObject> objects) {
        Collection reviews = Collections2.filter(objects, this.IN_VISIBLE_STATE);
        if (reviews.size() > 0) {
            ImmutableListMultimap stateCollections = Multimaps.index((Iterable)reviews, ReviewsObject.TO_STATE);
            for (ReviewsObject.ReviewState state : VISIBLE_STATES) {
                Collection reviewsInState = stateCollections.get((Object)state);
                if (reviewsInState.isEmpty()) continue;
                Option<Date> dueDate = AggregatorUtils.maxDate(reviewsInState, ReviewsObject.TO_DUE_DATE, (Ordering<Comparable>)Ordering.natural().reverse());
                if (COMPLETED_STATES.contains((Object)state) || dueDate.isEmpty()) {
                    Option<Date> lastUpdated = AggregatorUtils.maxDate(reviewsInState, ReviewsObject.TO_LAST_UPDATED);
                    return new ReviewsOverallBean(reviews.size(), null, (Date)lastUpdated.getOrNull(), reviewsInState.size(), state);
                }
                return new ReviewsOverallBean(reviews.size(), (Date)dueDate.getOrNull(), null, reviewsInState.size(), state);
            }
        }
        return new ReviewsOverallBean(0, null, null, 0, null);
    }

    @Override
    public ReviewsObject convertJsonNode(SummaryObjectMap summaryObject) {
        return summaryObject.as(ReviewsObject.class);
    }

    public static class ReviewsOverallBean
    extends OverallBean {
        @JsonProperty
        public final int stateCount;
        @JsonProperty
        public final String state;
        @JsonProperty
        private final String dueDate;
        @JsonProperty
        protected final boolean overDue;

        public ReviewsOverallBean(int count, Date dueDate, Date lastUpdated, int stateCount, ReviewsObject.ReviewState state) {
            super(count, lastUpdated);
            this.dueDate = dueDate == null ? null : Dates.asTimeString((Date)dueDate);
            this.stateCount = stateCount;
            this.state = state == null ? null : state.name();
            this.overDue = dueDate != null && new Date().after(dueDate);
        }
    }
}

