/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fugue.Option;
import com.atlassian.fusion.schema.common.PullRequestState;
import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.objects.PullRequestsObject;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.AggregatorHelper;
import com.atlassian.jira.plugin.devstatus.summary.beans.OverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.plugin.devstatus.summary.util.AggregatorUtils;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Date;
import javax.inject.Named;
import org.codehaus.jackson.annotate.JsonProperty;

@Named
public class PullRequestAggregator
implements Aggregator,
AggregatorHelper.JsonAggregator<PullRequestsObject> {
    @Override
    public String getType() {
        return PullRequestsObject.ID.getId();
    }

    @Override
    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData, long issueId) {
        return AggregatorHelper.create(this).aggregate(summaryData);
    }

    public PullRequestOverallBean aggregateDataObjects(Collection<PullRequestsObject> objects) {
        ImmutableListMultimap states = Multimaps.index(objects, PullRequestsObject.TO_STATE);
        for (PullRequestState state : PullRequestState.values()) {
            Collection prs = states.get((Object)state);
            if (prs.isEmpty()) continue;
            Option<Date> lastUpdated = AggregatorUtils.maxDate(prs, SummaryObject.TO_LAST_UPDATED);
            return new PullRequestOverallBean(objects.size(), (Date)lastUpdated.getOrNull(), prs.size(), state);
        }
        return new PullRequestOverallBean(0, null, 0, PullRequestState.OPEN);
    }

    @Override
    public PullRequestsObject convertJsonNode(SummaryObjectMap summaryObject) {
        return summaryObject.as(PullRequestsObject.class);
    }

    public static class PullRequestOverallBean
    extends OverallBean {
        @JsonProperty
        public int stateCount;
        @JsonProperty
        public String state;

        public PullRequestOverallBean(int count, Date lastUpdated, int stateCount, PullRequestState state) {
            super(count, lastUpdated);
            this.stateCount = stateCount;
            this.state = state.name();
        }
    }
}

