/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fugue.Pair;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.objects.CommitsObject;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.AggregatorHelper;
import com.atlassian.jira.plugin.devstatus.summary.beans.CommitOverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.plugin.devstatus.summary.util.AggregatorUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;

@Named
public class CommitAggregator
implements Aggregator,
AggregatorHelper.JsonAggregator<CommitsObject> {
    private static final Set<String> DVCS_TYPES = ImmutableSet.copyOf((Object[])System.getProperty("jira.devstatus.dvcs.types", "git|hg").split("\\|"));

    @Override
    public String getType() {
        return CommitsObject.ID.getId();
    }

    @Override
    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData, long issueId) {
        return AggregatorHelper.create(this).aggregate(summaryData);
    }

    public CommitOverallBean aggregateDataObjects(Collection<CommitsObject> commitsList) {
        return new CommitOverallBean(this.aggregateCommitCount(commitsList), this.aggregateLastUpdated(commitsList));
    }

    private int aggregateCommitCount(Collection<CommitsObject> commitsList) {
        ImmutableListMultimap commitsByType = Multimaps.index(commitsList, (Function)Functions.forPredicate((Predicate)Predicates.compose((Predicate)Predicates.in(DVCS_TYPES), CommitsObject.TO_TYPE)));
        int count = this.countCommits(commitsByType.get((Object)true));
        for (CommitsObject commits : commitsByType.get((Object)false)) {
            count += commits.getCount();
        }
        return count;
    }

    private int countCommits(Iterable<CommitsObject> commitsList) {
        return AggregatorUtils.countUnique(Iterables.transform(commitsList, (Function)new Function<CommitsObject, Pair<Integer, Collection<String>>>(){

            public Pair<Integer, Collection<String>> apply(CommitsObject input) {
                return Pair.pair((Object)input.getCount(), input.getCommits());
            }
        }));
    }

    @VisibleForTesting
    Date aggregateLastUpdated(Collection<CommitsObject> commitsList) {
        return (Date)AggregatorUtils.maxDate(commitsList, new Function<CommitsObject, Date>(){

            public Date apply(@Nullable CommitsObject input) {
                return input == null ? null : input.getLastUpdated();
            }
        }).getOrNull();
    }

    @Override
    public CommitsObject convertJsonNode(SummaryObjectMap summaryObject) {
        return summaryObject.as(CommitsObject.class);
    }
}

