/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fugue.Option;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.objects.BranchesObject;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.AggregatorHelper;
import com.atlassian.jira.plugin.devstatus.summary.beans.OverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.plugin.devstatus.summary.util.AggregatorUtils;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Date;
import javax.inject.Named;

@Named
public class BranchAggregator
implements Aggregator,
AggregatorHelper.JsonAggregator<BranchesObject> {
    @Override
    public String getType() {
        return BranchesObject.ID.getId();
    }

    @Override
    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData, long issueId) {
        return AggregatorHelper.create(this).aggregate(summaryData);
    }

    @Override
    public OverallBean aggregateDataObjects(Collection<BranchesObject> objects) {
        Option<Date> lastUpdated = AggregatorUtils.maxDate(objects, new Function<BranchesObject, Date>(){

            public Date apply(BranchesObject branch) {
                return branch.getLastUpdated();
            }
        });
        int branchCount = 0;
        for (BranchesObject branches : objects) {
            branchCount += Math.max(branches.getCount(), branches.getBranches().size());
        }
        return new OverallBean(branchCount, (Date)lastUpdated.getOrNull());
    }

    @Override
    public BranchesObject convertJsonNode(SummaryObjectMap summaryObject) {
        return summaryObject.as(BranchesObject.class);
    }
}

