/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.beans.ObjectByInstanceTypeBean;
import com.atlassian.jira.plugin.devstatus.summary.beans.OverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.plugin.devstatus.util.EqualableBean;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorHelper<T> {
    private static final Logger logger = LoggerFactory.getLogger(AggregatorHelper.class);
    public final JsonAggregator<T> aggregator;

    private AggregatorHelper(JsonAggregator<T> aggregator) {
        this.aggregator = aggregator;
    }

    public static <T> AggregatorHelper<T> create(JsonAggregator<T> aggregator) {
        return new AggregatorHelper<T>(aggregator);
    }

    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData) {
        Collection jsonObjectWithInstances = this.convertToJson(summaryData);
        Map<String, JsonObjectWithInstance<OverallBean>> aggregatedByInstanceType = this.aggregateByInstanceType(jsonObjectWithInstances);
        OverallBean overallBean = this.aggregator.aggregateDataObjects(AggregatorHelper.convertToList(jsonObjectWithInstances));
        Map aggregatedByInstanceTypeBean = Maps.transformEntries(aggregatedByInstanceType, (Maps.EntryTransformer)new Maps.EntryTransformer<String, JsonObjectWithInstance<OverallBean>, ObjectByInstanceTypeBean>(){

            public ObjectByInstanceTypeBean transformEntry(String instanceType, JsonObjectWithInstance<OverallBean> commitsObjectWithInstance) {
                return new ObjectByInstanceTypeBean(((OverallBean)((JsonObjectWithInstance)commitsObjectWithInstance).data).getCount(), ((JsonObjectWithInstance)commitsObjectWithInstance).instance.getTypeName());
            }
        });
        return new SummaryItemBean(overallBean, aggregatedByInstanceTypeBean);
    }

    @VisibleForTesting
    Map<String, JsonObjectWithInstance<OverallBean>> aggregateByInstanceType(Iterable<JsonObjectWithInstance<T>> jsonObjectWithInstances) {
        ImmutableMap groupedByInstanceType = Multimaps.index(jsonObjectWithInstances, (Function)new Function<JsonObjectWithInstance<T>, String>(){

            public String apply(JsonObjectWithInstance<T> input) {
                return input.instance.getType();
            }
        }).asMap();
        Map transformed = Maps.transformEntries((Map)groupedByInstanceType, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Collection<JsonObjectWithInstance<T>>, JsonObjectWithInstance<OverallBean>>(){

            public JsonObjectWithInstance<OverallBean> transformEntry(String instanceType, Collection<JsonObjectWithInstance<T>> jsonObjectWithInstanceList) {
                Source instance = jsonObjectWithInstanceList.iterator().next().instance;
                Collection commitsList = AggregatorHelper.convertToList(jsonObjectWithInstanceList);
                OverallBean aggregated = AggregatorHelper.this.aggregator.aggregateDataObjects(commitsList);
                return aggregated.getCount() == 0 ? null : new JsonObjectWithInstance<OverallBean>(instance, aggregated);
            }
        });
        return Maps.filterValues((Map)transformed, (Predicate)Predicates.notNull());
    }

    private Collection<JsonObjectWithInstance<T>> convertToJson(Collection<SummaryJsonDataItemWithSource> summaryData) {
        ImmutableList.Builder jsonObjects = ImmutableList.builder();
        for (SummaryJsonDataItemWithSource summaryDataItem : summaryData) {
            try {
                T data = this.aggregator.convertJsonNode(summaryDataItem.getObject());
                jsonObjects.add(new JsonObjectWithInstance<T>(summaryDataItem.getSource(), data));
            }
            catch (Exception e) {
                logger.warn("Error converting: " + summaryDataItem, (Throwable)e);
            }
        }
        return jsonObjects.build();
    }

    private static <A> Collection<A> convertToList(Collection<JsonObjectWithInstance<A>> jsonObjectWithInstanceList) {
        return Collections2.transform(jsonObjectWithInstanceList, (Function)new Function<JsonObjectWithInstance<A>, A>(){

            public A apply(JsonObjectWithInstance<A> input) {
                return input.data;
            }
        });
    }

    public static interface JsonAggregator<T> {
        public T convertJsonNode(SummaryObjectMap var1);

        public OverallBean aggregateDataObjects(Collection<T> var1);
    }

    @VisibleForTesting
    static class JsonObjectWithInstance<A>
    extends EqualableBean {
        private final Source instance;
        private final A data;

        public JsonObjectWithInstance(Source instance, A data) {
            this.instance = instance;
            this.data = data;
        }
    }
}

